/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.ma.ema;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.RecursiveIndicator;
import trade.invision.indicators.indicators.ma.sma.SimpleMovingAverage;
import trade.invision.num.Num;

public class ZeroLagExponentialMovingAverage
extends RecursiveIndicator<Num> {
    private static final Cache<CacheKey, ZeroLagExponentialMovingAverage> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> indicator;
    private final int length;
    private final Num k;
    private final int lag;
    private final SimpleMovingAverage initialSma;

    public static ZeroLagExponentialMovingAverage zlema(Indicator<Num> indicator, int length) {
        return ZeroLagExponentialMovingAverage.zeroLagExponentialMovingAverage(indicator, length);
    }

    public static ZeroLagExponentialMovingAverage zeroLagExponentialMovingAverage(Indicator<Num> indicator, int length) {
        return (ZeroLagExponentialMovingAverage)CACHE.get((Object)new CacheKey(indicator, length), key -> new ZeroLagExponentialMovingAverage(indicator, length));
    }

    protected ZeroLagExponentialMovingAverage(Indicator<Num> indicator, int length) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.indicator = indicator.caching();
        this.length = length;
        this.k = this.numOfTwo().divide((Number)(length + 1));
        this.lag = (int)Math.rint(((double)length - 1.0) / 2.0);
        this.initialSma = SimpleMovingAverage.simpleMovingAverage(indicator, length);
    }

    @Override
    protected Num calculate(long index) {
        if (index == 0L) {
            return this.indicator.getValue(0L);
        }
        if (index + 1L < (long)this.length) {
            return (Num)this.initialSma.getValue(index);
        }
        Num previousValue = (Num)this.getValue(index - 1L);
        return this.k.multiply(this.numOfTwo().multiply(this.indicator.getValue(index)).subtract(this.indicator.getValue(index - (long)this.lag))).add(this.numOfOne().subtract(this.k).multiply(previousValue));
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length) {
            this.indicator = indicator;
            this.length = length;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ZeroLagExponentialMovingAverage.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ")";
        }
    }
}

