/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.mf;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.bar.Volume;
import trade.invision.indicators.indicators.barprice.Hlc3;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class MoneyFlow
extends Indicator<Num> {
    private static final Cache<CacheKey, MoneyFlow> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Hlc3 hlc3;
    private final Volume volume;

    public static MoneyFlow mf(BarSeries barSeries) {
        return MoneyFlow.moneyFlow(barSeries);
    }

    public static MoneyFlow moneyFlow(BarSeries barSeries) {
        return (MoneyFlow)CACHE.get((Object)new CacheKey(barSeries), key -> new MoneyFlow(barSeries));
    }

    protected MoneyFlow(BarSeries barSeries) {
        super(barSeries, 0);
        this.hlc3 = Hlc3.hlc3(barSeries);
        this.volume = Volume.volume(barSeries);
    }

    @Override
    protected Num calculate(long index) {
        return ((Num)this.hlc3.getValue(index)).multiply((Num)this.volume.getValue(index));
    }

    private static final class CacheKey {
        private final BarSeries barSeries;

        @Generated
        public CacheKey(BarSeries barSeries) {
            this.barSeries = barSeries;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            return !(this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MoneyFlow.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ")";
        }
    }
}

