/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.mf;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.cumulative.CumulativeSum;
import trade.invision.indicators.indicators.mf.directional.DirectionalMoneyFlow;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class MoneyFlowIndex
extends Indicator<Num> {
    private static final Cache<CacheKey, MoneyFlowIndex> CACHE = Caffeine.newBuilder().weakValues().build();
    private final CumulativeSum positiveMoneyFlow;
    private final CumulativeSum negativeMoneyFlow;

    public static MoneyFlowIndex mf(BarSeries barSeries, int length) {
        return MoneyFlowIndex.moneyFlowIndex(barSeries, length);
    }

    public static MoneyFlowIndex moneyFlowIndex(BarSeries barSeries, int length) {
        return (MoneyFlowIndex)CACHE.get((Object)new CacheKey(barSeries, length), key -> new MoneyFlowIndex(barSeries, length));
    }

    protected MoneyFlowIndex(BarSeries barSeries, int length) {
        super(barSeries, length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.positiveMoneyFlow = CumulativeSum.cumulativeSum(DirectionalMoneyFlow.positiveDirectionalMoneyFlow(barSeries), length);
        this.negativeMoneyFlow = CumulativeSum.cumulativeSum(DirectionalMoneyFlow.negativeDirectionalMoneyFlow(barSeries), length);
    }

    @Override
    protected Num calculate(long index) {
        Num positiveMoneyFlowSum = (Num)this.positiveMoneyFlow.getValue(index);
        Num negativeMoneyFlowSum = (Num)this.negativeMoneyFlow.getValue(index);
        return this.numOfHundred().subtract(this.numOfHundred().divide(this.numOfOne().add(positiveMoneyFlowSum.divide(negativeMoneyFlowSum)))).ifNaN(this.numOfHundred());
    }

    private static final class CacheKey {
        private final BarSeries barSeries;
        private final int length;

        @Generated
        public CacheKey(BarSeries barSeries, int length) {
            this.barSeries = barSeries;
            this.length = length;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            return !(this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MoneyFlowIndex.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ", length=" + this.getLength() + ")";
        }
    }
}

