/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.operation.ternary;

import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.operation.ternary.TriFunction;

public class TernaryOperation<A, B, C, R>
extends Indicator<R> {
    private final TriFunction<A, B, C, R> operator;
    private final Indicator<A> firstOperand;
    private final Indicator<B> secondOperand;
    private final Indicator<C> thirdOperand;

    public static <A, B, C, R> TernaryOperation<A, B, C, R> ternaryOperation(TriFunction<A, B, C, R> operator, Indicator<A> firstOperand, Indicator<B> secondOperand, Indicator<C> thirdOperand) {
        return new TernaryOperation<A, B, C, R>(operator, firstOperand, secondOperand, thirdOperand);
    }

    protected TernaryOperation(TriFunction<A, B, C, R> operator, Indicator<A> firstOperand, Indicator<B> secondOperand, Indicator<C> thirdOperand) {
        super(firstOperand.getSeries(), Math.max(firstOperand.getMinimumStableIndex(), Math.max(secondOperand.getMinimumStableIndex(), thirdOperand.getMinimumStableIndex())));
        this.operator = operator;
        this.firstOperand = firstOperand;
        this.secondOperand = secondOperand;
        this.thirdOperand = thirdOperand;
    }

    @Override
    protected R calculate(long index) {
        return this.operator.apply(this.firstOperand.getValue(index), this.secondOperand.getValue(index), this.thirdOperand.getValue(index));
    }
}

