/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.random;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import trade.invision.indicators.indicators.CachingIndicator;
import trade.invision.indicators.series.Series;

public class RandomBoolean
extends CachingIndicator<Boolean> {
    private static final Cache<CacheKey, RandomBoolean> CACHE = Caffeine.newBuilder().weakValues().build();

    public static RandomBoolean randomBoolean(Series<?> series) {
        return (RandomBoolean)CACHE.get((Object)new CacheKey(series), key -> new RandomBoolean(series));
    }

    protected RandomBoolean(Series<?> series) {
        super(series, 0);
    }

    @Override
    protected Boolean calculate(long index) {
        return ThreadLocalRandom.current().nextBoolean();
    }

    private static final class CacheKey {
        private final Series<?> series;

        @Generated
        public CacheKey(Series<?> series) {
            this.series = series;
        }

        @Generated
        public Series<?> getSeries() {
            return this.series;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            Series<?> this$series = this.getSeries();
            Series<?> other$series = other.getSeries();
            return !(this$series == null ? other$series != null : !this$series.equals(other$series));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Series<?> $series = this.getSeries();
            result = result * 59 + ($series == null ? 43 : $series.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RandomBoolean.CacheKey(series=" + String.valueOf(this.getSeries()) + ")";
        }
    }
}

