/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.rvol;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.bar.Volume;
import trade.invision.indicators.indicators.ma.MovingAverageSupplier;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class RelativeVolume
extends Indicator<Num> {
    private static final Cache<CacheKey, RelativeVolume> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Volume volume;
    private final Indicator<Num> averageVolume;

    public static RelativeVolume rvol(BarSeries barSeries, int length, MovingAverageSupplier movingAverageSupplier) {
        return RelativeVolume.relativeVolume(barSeries, length, movingAverageSupplier);
    }

    public static RelativeVolume relativeVolume(BarSeries barSeries, int length, MovingAverageSupplier movingAverageSupplier) {
        return (RelativeVolume)CACHE.get((Object)new CacheKey(barSeries, length, movingAverageSupplier), key -> new RelativeVolume(barSeries, length, movingAverageSupplier));
    }

    protected RelativeVolume(BarSeries barSeries, int length, MovingAverageSupplier movingAverageSupplier) {
        super(barSeries, length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.volume = Volume.volume(barSeries);
        this.averageVolume = movingAverageSupplier.supply(this.volume, length);
    }

    @Override
    protected Num calculate(long index) {
        return ((Num)this.volume.getValue(index)).divide(this.averageVolume.getValue(index));
    }

    private static final class CacheKey {
        private final BarSeries barSeries;
        private final int length;
        private final MovingAverageSupplier movingAverageSupplier;

        @Generated
        public CacheKey(BarSeries barSeries, int length, MovingAverageSupplier movingAverageSupplier) {
            this.barSeries = barSeries;
            this.length = length;
            this.movingAverageSupplier = movingAverageSupplier;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public MovingAverageSupplier getMovingAverageSupplier() {
            return this.movingAverageSupplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            if (this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries)) {
                return false;
            }
            MovingAverageSupplier this$movingAverageSupplier = this.getMovingAverageSupplier();
            MovingAverageSupplier other$movingAverageSupplier = other.getMovingAverageSupplier();
            return !(this$movingAverageSupplier == null ? other$movingAverageSupplier != null : !((Object)this$movingAverageSupplier).equals(other$movingAverageSupplier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            MovingAverageSupplier $movingAverageSupplier = this.getMovingAverageSupplier();
            result = result * 59 + ($movingAverageSupplier == null ? 43 : ((Object)$movingAverageSupplier).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RelativeVolume.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ", length=" + this.getLength() + ", movingAverageSupplier=" + String.valueOf(this.getMovingAverageSupplier()) + ")";
        }
    }
}

