/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.statistical;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.statistical.Covariance;
import trade.invision.indicators.indicators.statistical.Variance;
import trade.invision.num.Num;

public class CorrelationCoefficient
extends Indicator<Num> {
    private static final Cache<CacheKey, CorrelationCoefficient> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Variance variance1;
    private final Variance variance2;
    private final Covariance covariance;

    public static CorrelationCoefficient cc(Indicator<Num> first, Indicator<Num> second, int length, boolean unbiased) {
        return CorrelationCoefficient.correlationCoefficient(first, second, length, unbiased);
    }

    public static CorrelationCoefficient correlationCoefficient(Indicator<Num> first, Indicator<Num> second, int length, boolean unbiased) {
        return (CorrelationCoefficient)CACHE.get((Object)new CacheKey(first, second, length, unbiased), key -> new CorrelationCoefficient(first, second, length, unbiased));
    }

    protected CorrelationCoefficient(Indicator<Num> first, Indicator<Num> second, int length, boolean unbiased) {
        super(first.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.variance1 = Variance.variance(first, length, unbiased);
        this.variance2 = Variance.variance(second, length, unbiased);
        this.covariance = Covariance.covariance(first, second, length, unbiased);
    }

    @Override
    protected Num calculate(long index) {
        return ((Num)this.covariance.getValue(index)).divide(((Num)this.variance1.getValue(index)).multiply((Num)this.variance2.getValue(index)).squareRoot());
    }

    private static final class CacheKey {
        private final Indicator<Num> first;
        private final Indicator<Num> second;
        private final int length;
        private final boolean unbiased;

        @Generated
        public CacheKey(Indicator<Num> first, Indicator<Num> second, int length, boolean unbiased) {
            this.first = first;
            this.second = second;
            this.length = length;
            this.unbiased = unbiased;
        }

        @Generated
        public Indicator<Num> getFirst() {
            return this.first;
        }

        @Generated
        public Indicator<Num> getSecond() {
            return this.second;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean isUnbiased() {
            return this.unbiased;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            if (this.isUnbiased() != other.isUnbiased()) {
                return false;
            }
            Indicator<Num> this$first = this.getFirst();
            Indicator<Num> other$first = other.getFirst();
            if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
                return false;
            }
            Indicator<Num> this$second = this.getSecond();
            Indicator<Num> other$second = other.getSecond();
            return !(this$second == null ? other$second != null : !this$second.equals(other$second));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            result = result * 59 + (this.isUnbiased() ? 79 : 97);
            Indicator<Num> $first = this.getFirst();
            result = result * 59 + ($first == null ? 43 : $first.hashCode());
            Indicator<Num> $second = this.getSecond();
            result = result * 59 + ($second == null ? 43 : $second.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CorrelationCoefficient.CacheKey(first=" + String.valueOf(this.getFirst()) + ", second=" + String.valueOf(this.getSecond()) + ", length=" + this.getLength() + ", unbiased=" + this.isUnbiased() + ")";
        }
    }
}

