/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.statistical;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.previous.PreviousRatio;
import trade.invision.num.Num;

public class GrowthRate
extends Indicator<Num> {
    private static final Cache<CacheKey, GrowthRate> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Num exponent;
    private final PreviousRatio previousRatio;

    public static GrowthRate gr(Indicator<Num> indicator, int length) {
        return GrowthRate.growthRate(indicator, length);
    }

    public static GrowthRate growthRate(Indicator<Num> indicator, int length) {
        return (GrowthRate)CACHE.get((Object)new CacheKey(indicator, length), key -> new GrowthRate(indicator, length));
    }

    protected GrowthRate(Indicator<Num> indicator, int length) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.exponent = this.numOf(length).reciprocal();
        this.previousRatio = PreviousRatio.previousRatio(indicator, length);
    }

    @Override
    protected Num calculate(long index) {
        return ((Num)this.previousRatio.getValue(index)).power(this.exponent).decrement();
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length) {
            this.indicator = indicator;
            this.length = length;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GrowthRate.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ")";
        }
    }
}

