/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.supertrend;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicators.RecursiveIndicator;
import trade.invision.indicators.indicators.bar.Close;
import trade.invision.indicators.indicators.ma.MovingAverageSupplier;
import trade.invision.indicators.indicators.supertrend.SupertrendLowerBand;
import trade.invision.indicators.indicators.supertrend.SupertrendUpperBand;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class Supertrend
extends RecursiveIndicator<Num> {
    private static final Cache<CacheKey, Supertrend> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Close close;
    private final SupertrendLowerBand lowerBand;
    private final SupertrendUpperBand upperBand;

    public static Supertrend supertrend(BarSeries barSeries, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier) {
        return (Supertrend)CACHE.get((Object)new CacheKey(barSeries, length, multiplier, movingAverageSupplier), key -> new Supertrend(barSeries, length, multiplier, movingAverageSupplier));
    }

    protected Supertrend(BarSeries barSeries, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier) {
        super(barSeries, length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.close = Close.close(barSeries);
        this.lowerBand = SupertrendLowerBand.supertrendLowerBand(barSeries, length, multiplier, movingAverageSupplier);
        this.upperBand = SupertrendUpperBand.supertrendUpperBand(barSeries, length, multiplier, movingAverageSupplier);
    }

    @Override
    protected Num calculate(long index) {
        if (index == 0L) {
            return this.numOfZero();
        }
        Num closePrice = (Num)this.close.getValue(index);
        Num previousValue = (Num)this.getValue(index - 1L);
        Num lower = (Num)this.lowerBand.getValue(index);
        Num upper = (Num)this.upperBand.getValue(index);
        if (previousValue.equals(this.upperBand.getValue(index - 1L))) {
            return closePrice.isGreaterThan(upper) ? lower : upper;
        }
        if (previousValue.equals(this.lowerBand.getValue(index - 1L))) {
            return closePrice.isLessThan(lower) ? upper : lower;
        }
        return previousValue;
    }

    private static final class CacheKey {
        private final BarSeries barSeries;
        private final int length;
        private final Num multiplier;
        private final MovingAverageSupplier movingAverageSupplier;

        @Generated
        public CacheKey(BarSeries barSeries, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier) {
            this.barSeries = barSeries;
            this.length = length;
            this.multiplier = multiplier;
            this.movingAverageSupplier = movingAverageSupplier;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public Num getMultiplier() {
            return this.multiplier;
        }

        @Generated
        public MovingAverageSupplier getMovingAverageSupplier() {
            return this.movingAverageSupplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            if (this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries)) {
                return false;
            }
            Num this$multiplier = this.getMultiplier();
            Num other$multiplier = other.getMultiplier();
            if (this$multiplier == null ? other$multiplier != null : !this$multiplier.equals(other$multiplier)) {
                return false;
            }
            MovingAverageSupplier this$movingAverageSupplier = this.getMovingAverageSupplier();
            MovingAverageSupplier other$movingAverageSupplier = other.getMovingAverageSupplier();
            return !(this$movingAverageSupplier == null ? other$movingAverageSupplier != null : !((Object)this$movingAverageSupplier).equals(other$movingAverageSupplier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            Num $multiplier = this.getMultiplier();
            result = result * 59 + ($multiplier == null ? 43 : $multiplier.hashCode());
            MovingAverageSupplier $movingAverageSupplier = this.getMovingAverageSupplier();
            result = result * 59 + ($movingAverageSupplier == null ? 43 : ((Object)$movingAverageSupplier).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Supertrend.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ", length=" + this.getLength() + ", multiplier=" + String.valueOf(this.getMultiplier()) + ", movingAverageSupplier=" + String.valueOf(this.getMovingAverageSupplier()) + ")";
        }
    }
}

