/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.supertrend;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Generated;
import trade.invision.indicators.indicators.RecursiveIndicator;
import trade.invision.indicators.indicators.bar.Close;
import trade.invision.indicators.indicators.barprice.Hl2;
import trade.invision.indicators.indicators.ma.MovingAverageSupplier;
import trade.invision.indicators.indicators.previous.PreviousValue;
import trade.invision.indicators.indicators.tr.AverageTrueRange;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class SupertrendLowerBand
extends RecursiveIndicator<Num> {
    private static final Cache<CacheKey, SupertrendLowerBand> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Num multiplier;
    private final AverageTrueRange atr;
    private final Hl2 hl2;
    private final PreviousValue<Num> previousClose;

    public static SupertrendLowerBand supertrendLowerBand(BarSeries barSeries, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier) {
        return (SupertrendLowerBand)CACHE.get((Object)new CacheKey(barSeries, length, multiplier, movingAverageSupplier), key -> new SupertrendLowerBand(barSeries, length, multiplier, movingAverageSupplier));
    }

    protected SupertrendLowerBand(BarSeries barSeries, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier) {
        super(barSeries, length - 1);
        this.multiplier = multiplier;
        this.atr = AverageTrueRange.averageTrueRange(barSeries, length, movingAverageSupplier);
        this.hl2 = Hl2.hl2(barSeries);
        this.previousClose = PreviousValue.previousValue(Close.close(barSeries));
    }

    @Override
    protected Num calculate(long index) {
        if (index == 0L) {
            return this.numOfZero();
        }
        Num currentBasic = ((Num)this.hl2.getValue(index)).subtract(this.multiplier.multiply((Num)this.atr.getValue(index)));
        Num previousValue = (Num)this.getValue(index - 1L);
        Num previousClosePrice = (Num)this.previousClose.getValue(index);
        return currentBasic.isGreaterThan(previousValue) || previousClosePrice.isLessThan(previousValue) ? currentBasic : previousValue;
    }

    private static final class CacheKey {
        private final BarSeries barSeries;
        private final int length;
        private final Num multiplier;
        private final MovingAverageSupplier movingAverageSupplier;

        @Generated
        public CacheKey(BarSeries barSeries, int length, Num multiplier, MovingAverageSupplier movingAverageSupplier) {
            this.barSeries = barSeries;
            this.length = length;
            this.multiplier = multiplier;
            this.movingAverageSupplier = movingAverageSupplier;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public Num getMultiplier() {
            return this.multiplier;
        }

        @Generated
        public MovingAverageSupplier getMovingAverageSupplier() {
            return this.movingAverageSupplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            if (this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries)) {
                return false;
            }
            Num this$multiplier = this.getMultiplier();
            Num other$multiplier = other.getMultiplier();
            if (this$multiplier == null ? other$multiplier != null : !this$multiplier.equals(other$multiplier)) {
                return false;
            }
            MovingAverageSupplier this$movingAverageSupplier = this.getMovingAverageSupplier();
            MovingAverageSupplier other$movingAverageSupplier = other.getMovingAverageSupplier();
            return !(this$movingAverageSupplier == null ? other$movingAverageSupplier != null : !((Object)this$movingAverageSupplier).equals(other$movingAverageSupplier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            Num $multiplier = this.getMultiplier();
            result = result * 59 + ($multiplier == null ? 43 : $multiplier.hashCode());
            MovingAverageSupplier $movingAverageSupplier = this.getMovingAverageSupplier();
            result = result * 59 + ($movingAverageSupplier == null ? 43 : ((Object)$movingAverageSupplier).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SupertrendLowerBand.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ", length=" + this.getLength() + ", multiplier=" + String.valueOf(this.getMultiplier()) + ", movingAverageSupplier=" + String.valueOf(this.getMovingAverageSupplier()) + ")";
        }
    }
}

