/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.vwap;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.bar.Volume;
import trade.invision.indicators.indicators.cumulative.CumulativeSum;
import trade.invision.indicators.indicators.mf.MoneyFlow;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class VolumeWeightedAveragePrice
extends Indicator<Num> {
    private static final Cache<CacheKey, VolumeWeightedAveragePrice> CACHE = Caffeine.newBuilder().weakValues().build();
    private final CumulativeSum cumulativeMoneyFlow;
    private final CumulativeSum cumulativeVolume;

    public static VolumeWeightedAveragePrice vwap(BarSeries barSeries, int length) {
        return VolumeWeightedAveragePrice.volumeWeightedAveragePrice(barSeries, length);
    }

    public static VolumeWeightedAveragePrice volumeWeightedAveragePrice(BarSeries barSeries, int length) {
        return (VolumeWeightedAveragePrice)CACHE.get((Object)new CacheKey(barSeries, length), key -> new VolumeWeightedAveragePrice(barSeries, length));
    }

    protected VolumeWeightedAveragePrice(BarSeries barSeries, int length) {
        super(barSeries, length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.cumulativeMoneyFlow = CumulativeSum.cumulativeSum(MoneyFlow.moneyFlow(barSeries), length);
        this.cumulativeVolume = CumulativeSum.cumulativeSum(Volume.volume(barSeries), length);
    }

    @Override
    protected Num calculate(long index) {
        return ((Num)this.cumulativeMoneyFlow.getValue(index)).divide((Num)this.cumulativeVolume.getValue(index));
    }

    private static final class CacheKey {
        private final BarSeries barSeries;
        private final int length;

        @Generated
        public CacheKey(BarSeries barSeries, int length) {
            this.barSeries = barSeries;
            this.length = length;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            return !(this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "VolumeWeightedAveragePrice.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ", length=" + this.getLength() + ")";
        }
    }
}

