/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.extrema.global;

import java.util.function.BiPredicate;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.RecursiveIndicator;
import trade.invision.num.Num;

abstract class AbstractGlobalExtrema
extends RecursiveIndicator<Num> {
    private final Indicator<Num> indicator;
    private final BiPredicate<Num, Num> predicate;

    public AbstractGlobalExtrema(Indicator<Num> indicator, boolean maximum) {
        super(indicator.getSeries(), 0);
        this.indicator = indicator;
        this.predicate = maximum ? Num::isGreaterThan : Num::isLessThan;
    }

    @Override
    protected Num calculate(long index) {
        Num previousValue;
        if (index == 0L) {
            return this.indicator.getValue(index);
        }
        Num currentValue = this.indicator.getValue(index);
        return this.predicate.test(currentValue, previousValue = (Num)this.getValue(index - 1L)) ? currentValue : previousValue;
    }
}

