/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.instant;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.num.Num;

public class DateTimeField
extends Indicator<Num> {
    private static final Cache<CacheKey, DateTimeField> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Instant> indicator;
    private final ChronoField field;
    private final ZoneId zoneId;

    public static DateTimeField dateTimeField(Indicator<Instant> indicator, ChronoField field) {
        return DateTimeField.dateTimeField(indicator, field, ZoneOffset.UTC);
    }

    public static DateTimeField dateTimeField(Indicator<Instant> indicator, ChronoField field, ZoneId zoneId) {
        return (DateTimeField)CACHE.get((Object)new CacheKey(indicator, field, zoneId), key -> new DateTimeField(indicator, field, zoneId));
    }

    protected DateTimeField(Indicator<Instant> indicator, ChronoField field, ZoneId zoneId) {
        super(indicator.getSeries(), 0);
        this.indicator = indicator;
        this.field = field;
        this.zoneId = zoneId;
    }

    @Override
    protected Num calculate(long index) {
        return this.numOf(this.indicator.getValue(index).atZone(this.zoneId).get(this.field));
    }

    private static final class CacheKey {
        private final Indicator<Instant> indicator;
        private final ChronoField field;
        private final ZoneId zoneId;

        @Generated
        public CacheKey(Indicator<Instant> indicator, ChronoField field, ZoneId zoneId) {
            this.indicator = indicator;
            this.field = field;
            this.zoneId = zoneId;
        }

        @Generated
        public Indicator<Instant> getIndicator() {
            return this.indicator;
        }

        @Generated
        public ChronoField getField() {
            return this.field;
        }

        @Generated
        public ZoneId getZoneId() {
            return this.zoneId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            Indicator<Instant> this$indicator = this.getIndicator();
            Indicator<Instant> other$indicator = other.getIndicator();
            if (this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator)) {
                return false;
            }
            ChronoField this$field = this.getField();
            ChronoField other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            ZoneId this$zoneId = this.getZoneId();
            ZoneId other$zoneId = other.getZoneId();
            return !(this$zoneId == null ? other$zoneId != null : !((Object)this$zoneId).equals(other$zoneId));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Indicator<Instant> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            ChronoField $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            ZoneId $zoneId = this.getZoneId();
            result = result * 59 + ($zoneId == null ? 43 : ((Object)$zoneId).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DateTimeField.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", field=" + String.valueOf(this.getField()) + ", zoneId=" + String.valueOf(this.getZoneId()) + ")";
        }
    }
}

