/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.instant;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.num.Num;

public class EpochOffset
extends Indicator<Num> {
    private static final Cache<CacheKey, EpochOffset> CACHE = Caffeine.newBuilder().weakValues().build();
    private static final ZonedDateTime EPOCH_AT_UTC = Instant.EPOCH.atZone(ZoneOffset.UTC);
    private final Indicator<Instant> indicator;
    private final ChronoUnit unit;

    public static EpochOffset epochOffset(Indicator<Instant> indicator, ChronoUnit unit) {
        return (EpochOffset)CACHE.get((Object)new CacheKey(indicator, unit), key -> new EpochOffset(indicator, unit));
    }

    protected EpochOffset(Indicator<Instant> indicator, ChronoUnit unit) {
        super(indicator.getSeries(), 0);
        this.indicator = indicator;
        this.unit = unit;
    }

    @Override
    protected Num calculate(long index) {
        return this.numOf(this.unit.between(EPOCH_AT_UTC, this.indicator.getValue(index).atZone(ZoneOffset.UTC)));
    }

    private static final class CacheKey {
        private final Indicator<Instant> indicator;
        private final ChronoUnit unit;

        @Generated
        public CacheKey(Indicator<Instant> indicator, ChronoUnit unit) {
            this.indicator = indicator;
            this.unit = unit;
        }

        @Generated
        public Indicator<Instant> getIndicator() {
            return this.indicator;
        }

        @Generated
        public ChronoUnit getUnit() {
            return this.unit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            Indicator<Instant> this$indicator = this.getIndicator();
            Indicator<Instant> other$indicator = other.getIndicator();
            if (this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator)) {
                return false;
            }
            ChronoUnit this$unit = this.getUnit();
            ChronoUnit other$unit = other.getUnit();
            return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Indicator<Instant> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            ChronoUnit $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EpochOffset.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", unit=" + String.valueOf(this.getUnit()) + ")";
        }
    }
}

