/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.ma.lsma;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.statistical.regression.LinearRegression;
import trade.invision.num.Num;

public class LeastSquaresMovingAverage
extends Indicator<Num> {
    private static final Cache<CacheKey, LeastSquaresMovingAverage> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> linearRegressionY;

    public static LeastSquaresMovingAverage lsma(Indicator<Num> indicator, int length) {
        return LeastSquaresMovingAverage.leastSquaresMovingAverage(indicator, length);
    }

    public static LeastSquaresMovingAverage leastSquaresMovingAverage(Indicator<Num> indicator, int length) {
        return (LeastSquaresMovingAverage)CACHE.get((Object)new CacheKey(indicator, length), key -> new LeastSquaresMovingAverage(indicator, length));
    }

    protected LeastSquaresMovingAverage(Indicator<Num> indicator, int length) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.linearRegressionY = LinearRegression.linearRegressionY(indicator, length);
    }

    @Override
    protected Num calculate(long index) {
        return this.linearRegressionY.getValue(index);
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length) {
            this.indicator = indicator;
            this.length = length;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LeastSquaresMovingAverage.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ")";
        }
    }
}

