/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.nvi;

import java.util.function.BiPredicate;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.RecursiveIndicator;
import trade.invision.indicators.indicators.bar.Volume;
import trade.invision.indicators.indicators.closeprice.ClosePricePercentChange;
import trade.invision.indicators.indicators.previous.PreviousValue;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

abstract class AbstractPositiveNegativeVolumeIndex
extends RecursiveIndicator<Num> {
    private final Indicator<Num> volume;
    private final Indicator<Num> previousVolume;
    private final ClosePricePercentChange closePricePercentChange;
    private final BiPredicate<Num, Num> predicate;

    public AbstractPositiveNegativeVolumeIndex(BarSeries barSeries, boolean positive) {
        super(barSeries, 1);
        this.volume = Volume.volume(barSeries);
        this.previousVolume = PreviousValue.previousValue(this.volume);
        this.closePricePercentChange = ClosePricePercentChange.closePricePercentChange(barSeries);
        this.predicate = positive ? Num::isGreaterThan : Num::isLessThan;
    }

    @Override
    protected Num calculate(long index) {
        if (index == 0L) {
            return this.numOfHundred();
        }
        Num previousValue = (Num)this.getValue(index - 1L);
        if (this.predicate.test(this.volume.getValue(index), this.previousVolume.getValue(index))) {
            previousValue = previousValue.add(((Num)this.closePricePercentChange.getValue(index)).multiply(previousValue));
        }
        return previousValue;
    }
}

