/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.statistical;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.indicators.statistical.Variance;
import trade.invision.num.Num;

public class StandardDeviation
extends Indicator<Num> {
    private static final Cache<CacheKey, StandardDeviation> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Variance variance;

    public static StandardDeviation stddev(Indicator<Num> indicator, int length, boolean unbiased) {
        return StandardDeviation.standardDeviation(indicator, length, unbiased);
    }

    public static StandardDeviation standardDeviation(Indicator<Num> indicator, int length, boolean unbiased) {
        return (StandardDeviation)CACHE.get((Object)new CacheKey(indicator, length, unbiased), key -> new StandardDeviation(indicator, length, unbiased));
    }

    protected StandardDeviation(Indicator<Num> indicator, int length, boolean unbiased) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.variance = Variance.variance(indicator, length, unbiased);
    }

    @Override
    protected Num calculate(long index) {
        return ((Num)this.variance.getValue(index)).squareRoot();
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;
        private final boolean unbiased;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length, boolean unbiased) {
            this.indicator = indicator;
            this.length = length;
            this.unbiased = unbiased;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean isUnbiased() {
            return this.unbiased;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            if (this.isUnbiased() != other.isUnbiased()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            result = result * 59 + (this.isUnbiased() ? 79 : 97);
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StandardDeviation.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ", unbiased=" + this.isUnbiased() + ")";
        }
    }
}

