/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicators.tr;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Generated;
import trade.invision.indicators.indicators.Indicator;
import trade.invision.indicators.series.bar.Bar;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class TrueRange
extends Indicator<Num> {
    private static final Cache<CacheKey, TrueRange> CACHE = Caffeine.newBuilder().weakValues().build();
    private final BarSeries barSeries;

    public static TrueRange tr(BarSeries barSeries) {
        return TrueRange.trueRange(barSeries);
    }

    public static TrueRange trueRange(BarSeries barSeries) {
        return (TrueRange)CACHE.get((Object)new CacheKey(barSeries), key -> new TrueRange(barSeries));
    }

    protected TrueRange(BarSeries barSeries) {
        super(barSeries, 1);
        this.barSeries = barSeries;
    }

    @Override
    protected Num calculate(long index) {
        Bar currentBar = (Bar)this.barSeries.get(index);
        Num hl = currentBar.getHigh().subtract(currentBar.getLow()).absoluteValue();
        if (index == 0L) {
            return hl;
        }
        Bar previousBar = (Bar)this.barSeries.get(index - 1L);
        Num hc = currentBar.getHigh().subtract(previousBar.getClose()).absoluteValue();
        Num lc = currentBar.getLow().subtract(previousBar.getClose()).absoluteValue();
        return hl.maximum(hc.maximum(lc));
    }

    private static final class CacheKey {
        private final BarSeries barSeries;

        @Generated
        public CacheKey(BarSeries barSeries) {
            this.barSeries = barSeries;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            return !(this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TrueRange.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ")";
        }
    }
}

