/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator;

import java.math.BigDecimal;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import trade.invision.indicators.series.Series;
import trade.invision.num.Num;

public abstract class Indicator<T> {
    protected final Series<?> series;
    protected final int minimumStableIndex;
    @Nullable
    protected CacheSeries cacheSeries;
    protected long cachedIndex;
    @Nullable
    protected T cachedValue;
    protected long cachedAddCallCount;

    public Indicator(Series<?> series, int minimumStableIndex) {
        this.series = series;
        this.minimumStableIndex = minimumStableIndex;
        this.cachedIndex = -1L;
        this.cachedAddCallCount = -1L;
    }

    protected abstract T calculate(long var1);

    public T getValue(long index) {
        T value;
        if (index > this.series.getEndIndex()) {
            return this.calculate(index);
        }
        if (index < this.series.getStartIndex()) {
            return this.calculate(0L);
        }
        if (index == this.cachedIndex && this.series.getAddCallCount() == this.cachedAddCallCount) {
            return this.cachedValue;
        }
        if (this.cacheSeries != null) {
            for (long count = this.cacheSeries.getEndIndex(); count < this.series.getEndIndex(); ++count) {
                this.cacheSeries.add(null);
            }
            if (index == this.series.getEndIndex() && this.series.getAddCallCount() != this.cachedAddCallCount) {
                value = this.calculate(index);
                this.cacheSeries.replaceLast(value);
            } else {
                value = this.cacheSeries.get(index);
                if (value == null) {
                    value = this.calculate(index);
                    this.cacheSeries.set(index, value);
                }
            }
        } else {
            value = this.calculate(index);
        }
        this.cachedIndex = index;
        this.cachedValue = value;
        this.cachedAddCallCount = this.series.getAddCallCount();
        return value;
    }

    public <A extends Indicator<T>> A caching() {
        if (this.cacheSeries == null) {
            this.cacheSeries = new CacheSeries(this);
        }
        return (A)this;
    }

    protected void purgeCache() {
        if (this.cacheSeries != null) {
            this.cacheSeries = new CacheSeries(this);
        }
    }

    public boolean isCaching() {
        return this.cacheSeries != null;
    }

    protected Num numOf(Number number) {
        return this.series.getNumFactory().of(number);
    }

    protected Num numOf(BigDecimal bigDecimal) {
        return this.series.getNumFactory().of(bigDecimal);
    }

    protected Num numOf(String string) {
        return this.series.getNumFactory().of(string);
    }

    protected Num numOf(Num num) {
        return this.series.getNumFactory().of(num);
    }

    protected Num numOfNegativeOne() {
        return this.series.getNumFactory().negativeOne();
    }

    protected Num numOfZero() {
        return this.series.getNumFactory().zero();
    }

    protected Num numOfOne() {
        return this.series.getNumFactory().one();
    }

    protected Num numOfTwo() {
        return this.series.getNumFactory().two();
    }

    protected Num numOfThree() {
        return this.series.getNumFactory().three();
    }

    protected Num numOfFour() {
        return this.series.getNumFactory().four();
    }

    protected Num numOfFive() {
        return this.series.getNumFactory().five();
    }

    protected Num numOfSix() {
        return this.series.getNumFactory().six();
    }

    protected Num numOfSeven() {
        return this.series.getNumFactory().seven();
    }

    protected Num numOfEight() {
        return this.series.getNumFactory().eight();
    }

    protected Num numOfNine() {
        return this.series.getNumFactory().nine();
    }

    protected Num numOfTen() {
        return this.series.getNumFactory().ten();
    }

    protected Num numOfHundred() {
        return this.series.getNumFactory().hundred();
    }

    protected Num numOfThousand() {
        return this.series.getNumFactory().thousand();
    }

    protected Num numOfTenth() {
        return this.series.getNumFactory().tenth();
    }

    protected Num numOfHundredth() {
        return this.series.getNumFactory().hundredth();
    }

    protected Num numOfThousandth() {
        return this.series.getNumFactory().thousandth();
    }

    protected Num numOfHalf() {
        return this.series.getNumFactory().half();
    }

    @Generated
    public Series<?> getSeries() {
        return this.series;
    }

    @Generated
    public int getMinimumStableIndex() {
        return this.minimumStableIndex;
    }

    protected final class CacheSeries
    extends Series<T> {
        private CacheSeries(Indicator this$0) {
            super(this$0.series.getMaximumLength());
        }

        private void set(long index, T value) {
            this.values.set((int)(index - this.startIndex), value);
        }
    }
}

