/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.acdc;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.ma.MovingAverageSupplier;
import trade.invision.indicators.indicator.macd.MovingAverageConvergenceDivergence;
import trade.invision.num.Num;

public class AccelerationDeceleration
extends Indicator<Num> {
    private static final Cache<CacheKey, AccelerationDeceleration> CACHE = Caffeine.newBuilder().weakValues().build();
    private final MovingAverageConvergenceDivergence macd;
    private final Indicator<Num> averagingIndicator;

    public static AccelerationDeceleration acdc(Indicator<Num> indicator, int firstLength, int secondLength, MovingAverageSupplier movingAverageSupplier) {
        return AccelerationDeceleration.accelerationDeceleration(indicator, firstLength, secondLength, movingAverageSupplier);
    }

    public static AccelerationDeceleration accelerationDeceleration(Indicator<Num> indicator, int firstLength, int secondLength, MovingAverageSupplier movingAverageSupplier) {
        return (AccelerationDeceleration)CACHE.get((Object)new CacheKey(indicator, firstLength, secondLength, movingAverageSupplier), key -> new AccelerationDeceleration(indicator, firstLength, secondLength, movingAverageSupplier));
    }

    protected AccelerationDeceleration(Indicator<Num> indicator, int firstLength, int secondLength, MovingAverageSupplier movingAverageSupplier) {
        super(indicator.getSeries(), Math.max(firstLength, secondLength));
        Preconditions.checkArgument((firstLength > 0 ? 1 : 0) != 0, (Object)"'firstLength' must be greater than zero!");
        Preconditions.checkArgument((secondLength > 0 ? 1 : 0) != 0, (Object)"'secondLength' must be greater than zero!");
        this.macd = MovingAverageConvergenceDivergence.movingAverageConvergenceDivergence(indicator, firstLength, secondLength, movingAverageSupplier);
        this.averagingIndicator = movingAverageSupplier.supply(this.macd, firstLength);
    }

    @Override
    protected Num calculate(long index) {
        return ((Num)this.macd.getValue(index)).subtract(this.averagingIndicator.getValue(index));
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int firstLength;
        private final int secondLength;
        private final MovingAverageSupplier movingAverageSupplier;

        @Generated
        public CacheKey(Indicator<Num> indicator, int firstLength, int secondLength, MovingAverageSupplier movingAverageSupplier) {
            this.indicator = indicator;
            this.firstLength = firstLength;
            this.secondLength = secondLength;
            this.movingAverageSupplier = movingAverageSupplier;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getFirstLength() {
            return this.firstLength;
        }

        @Generated
        public int getSecondLength() {
            return this.secondLength;
        }

        @Generated
        public MovingAverageSupplier getMovingAverageSupplier() {
            return this.movingAverageSupplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getFirstLength() != other.getFirstLength()) {
                return false;
            }
            if (this.getSecondLength() != other.getSecondLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            if (this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator)) {
                return false;
            }
            MovingAverageSupplier this$movingAverageSupplier = this.getMovingAverageSupplier();
            MovingAverageSupplier other$movingAverageSupplier = other.getMovingAverageSupplier();
            return !(this$movingAverageSupplier == null ? other$movingAverageSupplier != null : !((Object)this$movingAverageSupplier).equals(other$movingAverageSupplier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFirstLength();
            result = result * 59 + this.getSecondLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            MovingAverageSupplier $movingAverageSupplier = this.getMovingAverageSupplier();
            result = result * 59 + ($movingAverageSupplier == null ? 43 : ((Object)$movingAverageSupplier).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccelerationDeceleration.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", firstLength=" + this.getFirstLength() + ", secondLength=" + this.getSecondLength() + ", movingAverageSupplier=" + String.valueOf(this.getMovingAverageSupplier()) + ")";
        }
    }
}

