/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.ad;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Generated;
import trade.invision.indicators.indicator.RecursiveIndicator;
import trade.invision.indicators.indicator.bar.Volume;
import trade.invision.indicators.indicator.clv.CloseLocationValue;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class AccumulationDistribution
extends RecursiveIndicator<Num> {
    private static final Cache<CacheKey, AccumulationDistribution> CACHE = Caffeine.newBuilder().weakValues().build();
    private final CloseLocationValue clv;
    private final Volume volume;

    public static AccumulationDistribution ad(BarSeries barSeries) {
        return AccumulationDistribution.accumulationDistribution(barSeries);
    }

    public static AccumulationDistribution accumulationDistribution(BarSeries barSeries) {
        return (AccumulationDistribution)CACHE.get((Object)new CacheKey(barSeries), key -> new AccumulationDistribution(barSeries));
    }

    protected AccumulationDistribution(BarSeries barSeries) {
        super(barSeries, 1);
        this.clv = CloseLocationValue.closeLocationValue(barSeries);
        this.volume = Volume.volume(barSeries);
    }

    @Override
    protected Num calculate(long index) {
        Num mfv = ((Num)this.clv.getValue(index)).multiply((Num)this.volume.getValue(index));
        if (index == 0L) {
            return mfv;
        }
        return mfv.add((Num)this.getValue(index - 1L));
    }

    private static final class CacheKey {
        private final BarSeries barSeries;

        @Generated
        public CacheKey(BarSeries barSeries) {
            this.barSeries = barSeries;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            return !(this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccumulationDistribution.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ")";
        }
    }
}

