/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.bar;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.series.bar.Bar;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class BarDuration
extends Indicator<Num> {
    private static final Cache<CacheKey, BarDuration> CACHE = Caffeine.newBuilder().weakValues().build();
    private final BarSeries barSeries;
    private final ChronoUnit unit;

    public static BarDuration barDuration(BarSeries barSeries, ChronoUnit unit) {
        return (BarDuration)CACHE.get((Object)new CacheKey(barSeries, unit), key -> new BarDuration(barSeries, unit));
    }

    protected BarDuration(BarSeries barSeries, ChronoUnit unit) {
        super(barSeries, 0);
        this.barSeries = barSeries;
        this.unit = unit;
    }

    @Override
    protected Num calculate(long index) {
        Bar bar = (Bar)this.barSeries.get(index);
        return this.numOf(this.unit.between(bar.getEnd().atZone(ZoneOffset.UTC), bar.getStart().atZone(ZoneOffset.UTC)));
    }

    private static final class CacheKey {
        private final BarSeries barSeries;
        private final ChronoUnit unit;

        @Generated
        public CacheKey(BarSeries barSeries, ChronoUnit unit) {
            this.barSeries = barSeries;
            this.unit = unit;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public ChronoUnit getUnit() {
            return this.unit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            if (this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries)) {
                return false;
            }
            ChronoUnit this$unit = this.getUnit();
            ChronoUnit other$unit = other.getUnit();
            return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            ChronoUnit $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BarDuration.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ", unit=" + String.valueOf(this.getUnit()) + ")";
        }
    }
}

