/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.bar;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.bar.Volume;
import trade.invision.indicators.indicator.barprice.Ohlc4;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class TradeAmount
extends Indicator<Num> {
    private static final Cache<CacheKey, TradeAmount> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Ohlc4 ohlc4;
    private final Volume volume;

    public static TradeAmount tradeAmount(BarSeries barSeries) {
        return (TradeAmount)CACHE.get((Object)new CacheKey(barSeries), key -> new TradeAmount(barSeries));
    }

    protected TradeAmount(BarSeries barSeries) {
        super(barSeries, 0);
        this.ohlc4 = Ohlc4.ohlc4(barSeries);
        this.volume = Volume.volume(barSeries);
    }

    @Override
    protected Num calculate(long index) {
        return ((Num)this.ohlc4.getValue(index)).multiply((Num)this.volume.getValue(index));
    }

    private static final class CacheKey {
        private final BarSeries barSeries;

        @Generated
        public CacheKey(BarSeries barSeries) {
            this.barSeries = barSeries;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            return !(this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TradeAmount.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ")";
        }
    }
}

