/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.barprice;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.series.bar.Bar;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class Hl2
extends Indicator<Num> {
    private static final Cache<CacheKey, Hl2> CACHE = Caffeine.newBuilder().weakValues().build();
    private final BarSeries barSeries;

    public static Hl2 medianPrice(BarSeries barSeries) {
        return Hl2.hl2(barSeries);
    }

    public static Hl2 hl2(BarSeries barSeries) {
        return (Hl2)CACHE.get((Object)new CacheKey(barSeries), key -> new Hl2(barSeries));
    }

    protected Hl2(BarSeries barSeries) {
        super(barSeries, 0);
        this.barSeries = barSeries;
    }

    @Override
    protected Num calculate(long index) {
        Bar bar = (Bar)this.barSeries.get(index);
        return bar.getHigh().add(bar.getLow()).divide(this.numOfTwo());
    }

    private static final class CacheKey {
        private final BarSeries barSeries;

        @Generated
        public CacheKey(BarSeries barSeries) {
            this.barSeries = barSeries;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            return !(this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Hl2.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ")";
        }
    }
}

