/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.bullishbearish.global;

import java.util.function.Predicate;
import trade.invision.indicators.indicator.RecursiveIndicator;
import trade.invision.indicators.series.bar.Bar;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

abstract class AbstractGlobalBullishBearishPercentage
extends RecursiveIndicator<Num> {
    private final BarSeries barSeries;
    private final Predicate<Bar> predicate;

    protected AbstractGlobalBullishBearishPercentage(BarSeries barSeries, boolean bullish) {
        super(barSeries, 0);
        this.barSeries = barSeries;
        this.predicate = bullish ? Bar::isBullish : Bar::isBearish;
    }

    @Override
    protected Num calculate(long index) {
        if (index == 0L) {
            return this.predicate.test((Bar)this.barSeries.get(index)) ? this.numOfOne() : this.numOfZero();
        }
        Num previousValue = (Num)this.getValue(index - 1L);
        Num count = previousValue.multiply((Number)index);
        if (this.predicate.test((Bar)this.barSeries.get(index))) {
            count = count.increment();
        }
        return count.divide((Number)(index + 1L));
    }
}

