/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.cci;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.ma.MovingAverageSupplier;
import trade.invision.indicators.indicator.statistical.MeanDeviation;
import trade.invision.num.Num;

public class CommodityChannelIndex
extends Indicator<Num> {
    private static final Cache<CacheKey, CommodityChannelIndex> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> indicator;
    private final Indicator<Num> averagingIndicator;
    private final MeanDeviation meanDeviation;
    private final Num fifteenThousands;

    public static CommodityChannelIndex cci(Indicator<Num> indicator, int length, MovingAverageSupplier movingAverageSupplier) {
        return CommodityChannelIndex.commodityChannelIndex(indicator, length, movingAverageSupplier);
    }

    public static CommodityChannelIndex commodityChannelIndex(Indicator<Num> indicator, int length, MovingAverageSupplier movingAverageSupplier) {
        return (CommodityChannelIndex)CACHE.get((Object)new CacheKey(indicator, length, movingAverageSupplier), key -> new CommodityChannelIndex(indicator, length, movingAverageSupplier));
    }

    protected CommodityChannelIndex(Indicator<Num> indicator, int length, MovingAverageSupplier movingAverageSupplier) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.indicator = indicator;
        this.averagingIndicator = movingAverageSupplier.supply(indicator, length);
        this.meanDeviation = MeanDeviation.meanDeviation(indicator, length);
        this.fifteenThousands = this.numOf("0.015");
    }

    @Override
    protected Num calculate(long index) {
        return this.indicator.getValue(index).subtract(this.averagingIndicator.getValue(index)).divide(this.fifteenThousands.multiply((Num)this.meanDeviation.getValue(index)));
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;
        private final MovingAverageSupplier movingAverageSupplier;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length, MovingAverageSupplier movingAverageSupplier) {
            this.indicator = indicator;
            this.length = length;
            this.movingAverageSupplier = movingAverageSupplier;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public MovingAverageSupplier getMovingAverageSupplier() {
            return this.movingAverageSupplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            if (this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator)) {
                return false;
            }
            MovingAverageSupplier this$movingAverageSupplier = this.getMovingAverageSupplier();
            MovingAverageSupplier other$movingAverageSupplier = other.getMovingAverageSupplier();
            return !(this$movingAverageSupplier == null ? other$movingAverageSupplier != null : !((Object)this$movingAverageSupplier).equals(other$movingAverageSupplier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            MovingAverageSupplier $movingAverageSupplier = this.getMovingAverageSupplier();
            result = result * 59 + ($movingAverageSupplier == null ? 43 : ((Object)$movingAverageSupplier).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CommodityChannelIndex.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ", movingAverageSupplier=" + String.valueOf(this.getMovingAverageSupplier()) + ")";
        }
    }
}

