/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.chaikin;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.bar.Volume;
import trade.invision.indicators.indicator.clv.CloseLocationValue;
import trade.invision.indicators.indicator.cumulative.CumulativeSum;
import trade.invision.indicators.indicator.operation.binary.NumBinaryOperations;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class ChaikinMoneyFlow
extends Indicator<Num> {
    private static final Cache<CacheKey, ChaikinMoneyFlow> CACHE = Caffeine.newBuilder().weakValues().build();
    private final CumulativeSum cumulativeNumerator;
    private final CumulativeSum cumulativeVolume;

    public static ChaikinMoneyFlow cmf(BarSeries barSeries, int length) {
        return ChaikinMoneyFlow.chaikinMoneyFlow(barSeries, length);
    }

    public static ChaikinMoneyFlow chaikinMoneyFlow(BarSeries barSeries, int length) {
        return (ChaikinMoneyFlow)CACHE.get((Object)new CacheKey(barSeries, length), key -> new ChaikinMoneyFlow(barSeries, length));
    }

    protected ChaikinMoneyFlow(BarSeries barSeries, int length) {
        super(barSeries, length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        Volume volume = Volume.volume(barSeries);
        this.cumulativeNumerator = CumulativeSum.cumulativeSum(NumBinaryOperations.multiply(CloseLocationValue.closeLocationValue(barSeries), volume), length);
        this.cumulativeVolume = CumulativeSum.cumulativeSum(volume, length);
    }

    @Override
    protected Num calculate(long index) {
        return ((Num)this.cumulativeNumerator.getValue(index)).divide((Num)this.cumulativeVolume.getValue(index));
    }

    private static final class CacheKey {
        private final BarSeries barSeries;
        private final int length;

        @Generated
        public CacheKey(BarSeries barSeries, int length) {
            this.barSeries = barSeries;
            this.length = length;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            return !(this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ChaikinMoneyFlow.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ", length=" + this.getLength() + ")";
        }
    }
}

