/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.chaikin;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.ad.AccumulationDistribution;
import trade.invision.indicators.indicator.ma.ema.ExponentialMovingAverage;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class ChaikinOscillator
extends Indicator<Num> {
    private static final Cache<CacheKey, ChaikinOscillator> CACHE = Caffeine.newBuilder().weakValues().build();
    private final AccumulationDistribution ad;
    private final ExponentialMovingAverage emaShort;
    private final ExponentialMovingAverage emaLong;

    public static ChaikinOscillator co(BarSeries barSeries, int shortEmaLength, int longEmaLength, Num smoothing) {
        return ChaikinOscillator.chaikinOscillator(barSeries, shortEmaLength, longEmaLength, smoothing);
    }

    public static ChaikinOscillator chaikinOscillator(BarSeries barSeries, int shortEmaLength, int longEmaLength, Num smoothing) {
        return (ChaikinOscillator)CACHE.get((Object)new CacheKey(barSeries, shortEmaLength, longEmaLength, smoothing), key -> new ChaikinOscillator(barSeries, shortEmaLength, longEmaLength, smoothing));
    }

    protected ChaikinOscillator(BarSeries barSeries, int shortEmaLength, int longEmaLength, Num smoothing) {
        super(barSeries, Math.max(shortEmaLength, longEmaLength));
        Preconditions.checkArgument((shortEmaLength > 0 ? 1 : 0) != 0, (Object)"'shortEmaLength' must be greater than zero!");
        Preconditions.checkArgument((longEmaLength > 0 ? 1 : 0) != 0, (Object)"'longEmaLength' must be greater than zero!");
        this.ad = AccumulationDistribution.accumulationDistribution(barSeries);
        this.emaShort = ExponentialMovingAverage.exponentialMovingAverage(this.ad, shortEmaLength, smoothing);
        this.emaLong = ExponentialMovingAverage.exponentialMovingAverage(this.ad, longEmaLength, smoothing);
    }

    @Override
    protected Num calculate(long index) {
        return ((Num)this.emaShort.getValue(index)).subtract((Num)this.emaLong.getValue(index));
    }

    private static final class CacheKey {
        private final BarSeries barSeries;
        private final int shortEmaLength;
        private final int longEmaLength;
        private final Num smoothing;

        @Generated
        public CacheKey(BarSeries barSeries, int shortEmaLength, int longEmaLength, Num smoothing) {
            this.barSeries = barSeries;
            this.shortEmaLength = shortEmaLength;
            this.longEmaLength = longEmaLength;
            this.smoothing = smoothing;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public int getShortEmaLength() {
            return this.shortEmaLength;
        }

        @Generated
        public int getLongEmaLength() {
            return this.longEmaLength;
        }

        @Generated
        public Num getSmoothing() {
            return this.smoothing;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getShortEmaLength() != other.getShortEmaLength()) {
                return false;
            }
            if (this.getLongEmaLength() != other.getLongEmaLength()) {
                return false;
            }
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            if (this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries)) {
                return false;
            }
            Num this$smoothing = this.getSmoothing();
            Num other$smoothing = other.getSmoothing();
            return !(this$smoothing == null ? other$smoothing != null : !this$smoothing.equals(other$smoothing));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getShortEmaLength();
            result = result * 59 + this.getLongEmaLength();
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            Num $smoothing = this.getSmoothing();
            result = result * 59 + ($smoothing == null ? 43 : $smoothing.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ChaikinOscillator.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ", shortEmaLength=" + this.getShortEmaLength() + ", longEmaLength=" + this.getLongEmaLength() + ", smoothing=" + String.valueOf(this.getSmoothing()) + ")";
        }
    }
}

