/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.cmo;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.cumulative.CumulativeSum;
import trade.invision.indicators.indicator.gainloss.Gain;
import trade.invision.indicators.indicator.gainloss.Loss;
import trade.invision.num.Num;

public class ChandeMomentumOscillator
extends Indicator<Num> {
    private static final Cache<CacheKey, ChandeMomentumOscillator> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> cumulativeGain;
    private final Indicator<Num> cumulativeLoss;

    public static ChandeMomentumOscillator cmo(Indicator<Num> indicator, int length) {
        return ChandeMomentumOscillator.chandeMomentumOscillator(indicator, length);
    }

    public static ChandeMomentumOscillator chandeMomentumOscillator(Indicator<Num> indicator, int length) {
        return (ChandeMomentumOscillator)CACHE.get((Object)new CacheKey(indicator, length), key -> new ChandeMomentumOscillator(indicator, length));
    }

    protected ChandeMomentumOscillator(Indicator<Num> indicator, int length) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.cumulativeGain = CumulativeSum.cumulativeSum(Gain.gain(indicator), length);
        this.cumulativeLoss = CumulativeSum.cumulativeSum(Loss.loss(indicator), length);
    }

    @Override
    protected Num calculate(long index) {
        Num cumulativeGainValue = this.cumulativeGain.getValue(index);
        Num cumulativeLossValue = this.cumulativeLoss.getValue(index);
        return cumulativeGainValue.subtract(cumulativeLossValue).divide(cumulativeGainValue.add(cumulativeLossValue)).multiply(this.numOfHundred());
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length) {
            this.indicator = indicator;
            this.length = length;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ChandeMomentumOscillator.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ")";
        }
    }
}

