/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.crossed;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.num.Num;

public class CrossedUp
extends Indicator<Boolean> {
    private static final Cache<CacheKey, CrossedUp> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> first;
    private final Indicator<Num> second;

    public static CrossedUp crossedUp(Indicator<Num> first, Indicator<Num> second) {
        return (CrossedUp)CACHE.get((Object)new CacheKey(first, second), key -> new CrossedUp(first, second));
    }

    protected CrossedUp(Indicator<Num> first, Indicator<Num> second) {
        super(first.getSeries(), Math.max(first.getMinimumStableIndex(), second.getMinimumStableIndex()));
        this.first = first.caching();
        this.second = second.caching();
    }

    @Override
    protected Boolean calculate(long index) {
        if (index == 0L || this.first.getValue(index).isLessThanOrEqual(this.second.getValue(index), this.series.getEpsilon())) {
            return false;
        }
        while (--index > 0L && this.first.getValue(index).isEqual(this.second.getValue(index), this.series.getEpsilon())) {
        }
        return this.first.getValue(index).isLessThan(this.second.getValue(index));
    }

    private static final class CacheKey {
        private final Indicator<Num> first;
        private final Indicator<Num> second;

        @Generated
        public CacheKey(Indicator<Num> first, Indicator<Num> second) {
            this.first = first;
            this.second = second;
        }

        @Generated
        public Indicator<Num> getFirst() {
            return this.first;
        }

        @Generated
        public Indicator<Num> getSecond() {
            return this.second;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            Indicator<Num> this$first = this.getFirst();
            Indicator<Num> other$first = other.getFirst();
            if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
                return false;
            }
            Indicator<Num> this$second = this.getSecond();
            Indicator<Num> other$second = other.getSecond();
            return !(this$second == null ? other$second != null : !this$second.equals(other$second));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Indicator<Num> $first = this.getFirst();
            result = result * 59 + ($first == null ? 43 : $first.hashCode());
            Indicator<Num> $second = this.getSecond();
            result = result * 59 + ($second == null ? 43 : $second.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CrossedUp.CacheKey(first=" + String.valueOf(this.getFirst()) + ", second=" + String.valueOf(this.getSecond()) + ")";
        }
    }
}

