/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.cumulative;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.num.Num;

public class CumulativeSum
extends Indicator<Num> {
    private static final Cache<CacheKey, CumulativeSum> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> indicator;
    private final int length;
    private long previousIndex;
    private Num previousValue;
    private Num previousSum;

    public static CumulativeSum summation(Indicator<Num> indicator, int length) {
        return CumulativeSum.cumulativeSum(indicator, length);
    }

    public static CumulativeSum cumulativeSum(Indicator<Num> indicator, int length) {
        return (CumulativeSum)CACHE.get((Object)new CacheKey(indicator, length), key -> new CumulativeSum(indicator, length));
    }

    protected CumulativeSum(Indicator<Num> indicator, int length) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.indicator = indicator.caching();
        this.length = length;
        this.previousIndex = -1L;
        this.previousValue = this.numOfZero();
        this.previousSum = this.numOfZero();
    }

    @Override
    protected Num calculate(long index) {
        Num sum;
        Num currentValue = this.indicator.getValue(index);
        if (index == this.previousIndex) {
            sum = this.previousSum.subtract(this.previousValue).add(currentValue);
        } else if (index == this.previousIndex + 1L) {
            sum = this.previousSum.add(currentValue);
            if (index >= (long)this.length) {
                sum = sum.subtract(this.indicator.getValue(index - (long)this.length));
            }
        } else {
            sum = this.numOfZero();
            for (long sumIndex = Math.max(0L, index - (long)this.length + 1L); sumIndex < index; ++sumIndex) {
                sum = sum.add(this.indicator.getValue(sumIndex));
            }
            sum = sum.add(currentValue);
        }
        this.previousIndex = index;
        this.previousValue = currentValue;
        this.previousSum = sum;
        return sum;
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length) {
            this.indicator = indicator;
            this.length = length;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CumulativeSum.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ")";
        }
    }
}

