/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.extrema.local;

import com.google.common.base.Preconditions;
import java.util.function.BiPredicate;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.num.Num;

abstract class AbstractLocalExtrema
extends Indicator<Num> {
    private final Indicator<Num> indicator;
    private final int length;
    private final BiPredicate<Num, Num> predicate;

    protected AbstractLocalExtrema(Indicator<Num> indicator, int length, boolean maximum) {
        super(indicator.getSeries(), 0);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.indicator = indicator.caching();
        this.length = length;
        this.predicate = maximum ? Num::isGreaterThan : Num::isLessThan;
    }

    @Override
    protected Num calculate(long index) {
        Num extrema = this.indicator.getValue(index);
        long endIndex = Math.max(0L, index - (long)this.length + 1L);
        for (long indicatorIndex = index - 1L; indicatorIndex >= endIndex; --indicatorIndex) {
            Num value = this.indicator.getValue(indicatorIndex);
            if (!this.predicate.test(value, extrema)) continue;
            extrema = value;
        }
        return extrema;
    }
}

