/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.instant;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.num.Num;

public class DurationBetween
extends Indicator<Num> {
    private static final Cache<CacheKey, DurationBetween> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Instant> first;
    private final Indicator<Instant> second;
    private final ChronoUnit unit;

    public static DurationBetween durationBetween(Indicator<Instant> first, Indicator<Instant> second, ChronoUnit unit) {
        return (DurationBetween)CACHE.get((Object)new CacheKey(first, second, unit), key -> new DurationBetween(first, second, unit));
    }

    protected DurationBetween(Indicator<Instant> first, Indicator<Instant> second, ChronoUnit unit) {
        super(first.getSeries(), 0);
        this.first = first;
        this.second = second;
        this.unit = unit;
    }

    @Override
    protected Num calculate(long index) {
        return this.numOf(this.unit.between(this.first.getValue(index).atZone(ZoneOffset.UTC), this.second.getValue(index).atZone(ZoneOffset.UTC)));
    }

    private static final class CacheKey {
        private final Indicator<Instant> first;
        private final Indicator<Instant> second;
        private final ChronoUnit unit;

        @Generated
        public CacheKey(Indicator<Instant> first, Indicator<Instant> second, ChronoUnit unit) {
            this.first = first;
            this.second = second;
            this.unit = unit;
        }

        @Generated
        public Indicator<Instant> getFirst() {
            return this.first;
        }

        @Generated
        public Indicator<Instant> getSecond() {
            return this.second;
        }

        @Generated
        public ChronoUnit getUnit() {
            return this.unit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            Indicator<Instant> this$first = this.getFirst();
            Indicator<Instant> other$first = other.getFirst();
            if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
                return false;
            }
            Indicator<Instant> this$second = this.getSecond();
            Indicator<Instant> other$second = other.getSecond();
            if (this$second == null ? other$second != null : !this$second.equals(other$second)) {
                return false;
            }
            ChronoUnit this$unit = this.getUnit();
            ChronoUnit other$unit = other.getUnit();
            return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Indicator<Instant> $first = this.getFirst();
            result = result * 59 + ($first == null ? 43 : $first.hashCode());
            Indicator<Instant> $second = this.getSecond();
            result = result * 59 + ($second == null ? 43 : $second.hashCode());
            ChronoUnit $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DurationBetween.CacheKey(first=" + String.valueOf(this.getFirst()) + ", second=" + String.valueOf(this.getSecond()) + ", unit=" + String.valueOf(this.getUnit()) + ")";
        }
    }
}

