/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.instant;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;

public class TruncateTo
extends Indicator<Instant> {
    private static final Cache<CacheKey, TruncateTo> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Instant> indicator;
    private final ChronoUnit unit;
    private final ZoneId zoneId;

    public static TruncateTo truncateTo(Indicator<Instant> indicator, ChronoUnit unit) {
        return TruncateTo.truncateTo(indicator, unit, ZoneOffset.UTC);
    }

    public static TruncateTo truncateTo(Indicator<Instant> indicator, ChronoUnit unit, ZoneId zoneId) {
        return (TruncateTo)CACHE.get((Object)new CacheKey(indicator, unit, zoneId), key -> new TruncateTo(indicator, unit, zoneId));
    }

    protected TruncateTo(Indicator<Instant> indicator, ChronoUnit unit, ZoneId zoneId) {
        super(indicator.getSeries(), 0);
        this.indicator = indicator;
        this.unit = unit;
        this.zoneId = zoneId;
    }

    @Override
    protected Instant calculate(long index) {
        return this.indicator.getValue(index).atZone(this.zoneId).truncatedTo(this.unit).toInstant();
    }

    private static final class CacheKey {
        private final Indicator<Instant> indicator;
        private final ChronoUnit unit;
        private final ZoneId zoneId;

        @Generated
        public CacheKey(Indicator<Instant> indicator, ChronoUnit unit, ZoneId zoneId) {
            this.indicator = indicator;
            this.unit = unit;
            this.zoneId = zoneId;
        }

        @Generated
        public Indicator<Instant> getIndicator() {
            return this.indicator;
        }

        @Generated
        public ChronoUnit getUnit() {
            return this.unit;
        }

        @Generated
        public ZoneId getZoneId() {
            return this.zoneId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            Indicator<Instant> this$indicator = this.getIndicator();
            Indicator<Instant> other$indicator = other.getIndicator();
            if (this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator)) {
                return false;
            }
            ChronoUnit this$unit = this.getUnit();
            ChronoUnit other$unit = other.getUnit();
            if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
                return false;
            }
            ZoneId this$zoneId = this.getZoneId();
            ZoneId other$zoneId = other.getZoneId();
            return !(this$zoneId == null ? other$zoneId != null : !((Object)this$zoneId).equals(other$zoneId));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Indicator<Instant> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            ChronoUnit $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            ZoneId $zoneId = this.getZoneId();
            result = result * 59 + ($zoneId == null ? 43 : ((Object)$zoneId).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TruncateTo.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", unit=" + String.valueOf(this.getUnit()) + ", zoneId=" + String.valueOf(this.getZoneId()) + ")";
        }
    }
}

