/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.ma.hma;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.constant.ConstantValue;
import trade.invision.indicators.indicator.ma.wma.WeightedMovingAverage;
import trade.invision.indicators.indicator.operation.binary.NumBinaryOperations;
import trade.invision.num.Num;

public class HullMovingAverage
extends Indicator<Num> {
    private static final Cache<CacheKey, HullMovingAverage> CACHE = Caffeine.newBuilder().weakValues().build();
    private final WeightedMovingAverage hma;

    public static HullMovingAverage hma(Indicator<Num> indicator, int length) {
        return HullMovingAverage.hullMovingAverage(indicator, length);
    }

    public static HullMovingAverage hullMovingAverage(Indicator<Num> indicator, int length) {
        return (HullMovingAverage)CACHE.get((Object)new CacheKey(indicator, length), key -> new HullMovingAverage(indicator, length));
    }

    protected HullMovingAverage(Indicator<Num> indicator, int length) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        WeightedMovingAverage halfWma = WeightedMovingAverage.weightedMovingAverage(indicator, (int)Math.rint((double)length / 2.0));
        WeightedMovingAverage wma = WeightedMovingAverage.weightedMovingAverage(indicator, length);
        Indicator<Num> inner = NumBinaryOperations.subtract(NumBinaryOperations.multiply(ConstantValue.constantValue(this.series, this.numOfTwo()), halfWma), wma);
        this.hma = WeightedMovingAverage.weightedMovingAverage(inner, (int)Math.rint(Math.sqrt(length)));
    }

    @Override
    protected Num calculate(long index) {
        return (Num)this.hma.getValue(index);
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length) {
            this.indicator = indicator;
            this.length = length;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "HullMovingAverage.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ")";
        }
    }
}

