/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.ma.kama;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.RecursiveIndicator;
import trade.invision.num.Num;

public class KaufmansAdaptiveMovingAverage
extends RecursiveIndicator<Num> {
    private static final Cache<CacheKey, KaufmansAdaptiveMovingAverage> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> indicator;
    private final int efficiencyRatioLength;
    private final Num fastest;
    private final Num slowest;

    public static KaufmansAdaptiveMovingAverage kama(Indicator<Num> indicator, int efficiencyRatioLength) {
        return KaufmansAdaptiveMovingAverage.kaufmansAdaptiveMovingAverage(indicator, efficiencyRatioLength);
    }

    public static KaufmansAdaptiveMovingAverage kaufmansAdaptiveMovingAverage(Indicator<Num> indicator, int efficiencyRatioLength) {
        return KaufmansAdaptiveMovingAverage.kaufmansAdaptiveMovingAverage(indicator, efficiencyRatioLength, Math.max(1, (int)Math.rint(2.0 * ((double)efficiencyRatioLength / 10.0))), Math.max(1, (int)Math.rint(30.0 * ((double)efficiencyRatioLength / 10.0))));
    }

    public static KaufmansAdaptiveMovingAverage kama(Indicator<Num> indicator, int efficiencyRatioLength, int fastLength, int slowLength) {
        return KaufmansAdaptiveMovingAverage.kaufmansAdaptiveMovingAverage(indicator, efficiencyRatioLength, fastLength, slowLength);
    }

    public static KaufmansAdaptiveMovingAverage kaufmansAdaptiveMovingAverage(Indicator<Num> indicator, int efficiencyRatioLength, int fastLength, int slowLength) {
        return (KaufmansAdaptiveMovingAverage)CACHE.get((Object)new CacheKey(indicator, efficiencyRatioLength, fastLength, slowLength), key -> new KaufmansAdaptiveMovingAverage(indicator, efficiencyRatioLength, fastLength, slowLength));
    }

    protected KaufmansAdaptiveMovingAverage(Indicator<Num> indicator, int efficiencyRatioLength, int fastLength, int slowLength) {
        super(indicator.getSeries(), Math.max(efficiencyRatioLength, Math.max(fastLength, slowLength)));
        Preconditions.checkArgument((efficiencyRatioLength > 0 ? 1 : 0) != 0, (Object)"'efficiencyRatioLength' must be greater than zero!");
        Preconditions.checkArgument((fastLength > 0 ? 1 : 0) != 0, (Object)"'fastLength' must be greater than zero!");
        Preconditions.checkArgument((slowLength > 0 ? 1 : 0) != 0, (Object)"'slowLength' must be greater than zero!");
        this.indicator = indicator.caching();
        this.efficiencyRatioLength = efficiencyRatioLength;
        this.fastest = this.numOfTwo().divide((Number)(fastLength + 1));
        this.slowest = this.numOfTwo().divide((Number)(slowLength + 1));
    }

    @Override
    protected Num calculate(long index) {
        Num currentValue = this.indicator.getValue(index);
        if (index < (long)this.efficiencyRatioLength) {
            return currentValue;
        }
        long startChangeIndex = Math.max(0L, index - (long)this.efficiencyRatioLength);
        Num change = currentValue.subtract(this.indicator.getValue(startChangeIndex)).absoluteValue();
        Num volatility = this.numOfZero();
        for (long indicatorIndex = startChangeIndex; indicatorIndex < index; ++indicatorIndex) {
            volatility = volatility.add(this.indicator.getValue(indicatorIndex + 1L).subtract(this.indicator.getValue(indicatorIndex)).absoluteValue());
        }
        Num er = change.divide(volatility);
        Num scInner = er.multiply(this.fastest.subtract(this.slowest)).add(this.slowest);
        Num previousValue = (Num)this.getValue(index - 1L);
        return previousValue.add(scInner.square().multiply(currentValue.subtract(previousValue)));
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int efficiencyRatioLength;
        private final int fastLength;
        private final int slowLength;

        @Generated
        public CacheKey(Indicator<Num> indicator, int efficiencyRatioLength, int fastLength, int slowLength) {
            this.indicator = indicator;
            this.efficiencyRatioLength = efficiencyRatioLength;
            this.fastLength = fastLength;
            this.slowLength = slowLength;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getEfficiencyRatioLength() {
            return this.efficiencyRatioLength;
        }

        @Generated
        public int getFastLength() {
            return this.fastLength;
        }

        @Generated
        public int getSlowLength() {
            return this.slowLength;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getEfficiencyRatioLength() != other.getEfficiencyRatioLength()) {
                return false;
            }
            if (this.getFastLength() != other.getFastLength()) {
                return false;
            }
            if (this.getSlowLength() != other.getSlowLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getEfficiencyRatioLength();
            result = result * 59 + this.getFastLength();
            result = result * 59 + this.getSlowLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "KaufmansAdaptiveMovingAverage.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", efficiencyRatioLength=" + this.getEfficiencyRatioLength() + ", fastLength=" + this.getFastLength() + ", slowLength=" + this.getSlowLength() + ")";
        }
    }
}

