/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.ma.lsma;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.statistical.regression.LinearRegression;
import trade.invision.num.Num;

public class PredictiveLeastSquaresMovingAverage
extends Indicator<Num> {
    private static final Cache<CacheKey, PredictiveLeastSquaresMovingAverage> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> linearRegressionNextY;

    public static PredictiveLeastSquaresMovingAverage plsma(Indicator<Num> indicator, int length) {
        return PredictiveLeastSquaresMovingAverage.predictiveLeastSquaresMovingAverage(indicator, length);
    }

    public static PredictiveLeastSquaresMovingAverage predictiveLeastSquaresMovingAverage(Indicator<Num> indicator, int length) {
        return (PredictiveLeastSquaresMovingAverage)CACHE.get((Object)new CacheKey(indicator, length), key -> new PredictiveLeastSquaresMovingAverage(indicator, length));
    }

    protected PredictiveLeastSquaresMovingAverage(Indicator<Num> indicator, int length) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.linearRegressionNextY = LinearRegression.linearRegressionNextY(indicator, length);
    }

    @Override
    protected Num calculate(long index) {
        return this.linearRegressionNextY.getValue(index);
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length) {
            this.indicator = indicator;
            this.length = length;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PredictiveLeastSquaresMovingAverage.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ")";
        }
    }
}

