/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.ma.wma;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.num.Num;

public class LinearlyWeightedMovingAverage
extends Indicator<Num> {
    private static final Cache<CacheKey, LinearlyWeightedMovingAverage> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> indicator;
    private final int length;

    public static LinearlyWeightedMovingAverage lwma(Indicator<Num> indicator, int length) {
        return LinearlyWeightedMovingAverage.linearlyWeightedMovingAverage(indicator, length);
    }

    public static LinearlyWeightedMovingAverage linearlyWeightedMovingAverage(Indicator<Num> indicator, int length) {
        return (LinearlyWeightedMovingAverage)CACHE.get((Object)new CacheKey(indicator, length), key -> new LinearlyWeightedMovingAverage(indicator, length));
    }

    protected LinearlyWeightedMovingAverage(Indicator<Num> indicator, int length) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.indicator = indicator.caching();
        this.length = length;
    }

    @Override
    protected Num calculate(long index) {
        Num weightedSum = this.numOfZero();
        long sumOfWeights = 0L;
        long loopLength = Math.min(index + 1L, (long)this.length);
        long indicatorIndex = index;
        for (long loopIndex = loopLength; loopIndex > 0L; --loopIndex) {
            weightedSum = weightedSum.add(this.indicator.getValue(indicatorIndex).multiply((Number)loopIndex));
            sumOfWeights += loopIndex;
            --indicatorIndex;
        }
        return weightedSum.divide((Number)sumOfWeights);
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length) {
            this.indicator = indicator;
            this.length = length;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LinearlyWeightedMovingAverage.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ")";
        }
    }
}

