/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.macd;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.ma.MovingAverageSupplier;
import trade.invision.num.Num;

public class MovingAverageConvergenceDivergence
extends Indicator<Num> {
    private static final Cache<CacheKey, MovingAverageConvergenceDivergence> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> shortMa;
    private final Indicator<Num> longMa;

    public static MovingAverageConvergenceDivergence macd(Indicator<Num> indicator, int shortLength, int longLength, MovingAverageSupplier movingAverageSupplier) {
        return MovingAverageConvergenceDivergence.movingAverageConvergenceDivergence(indicator, shortLength, longLength, movingAverageSupplier);
    }

    public static MovingAverageConvergenceDivergence movingAverageConvergenceDivergence(Indicator<Num> indicator, int shortLength, int longLength, MovingAverageSupplier movingAverageSupplier) {
        return (MovingAverageConvergenceDivergence)CACHE.get((Object)new CacheKey(indicator, shortLength, longLength, movingAverageSupplier), key -> new MovingAverageConvergenceDivergence(indicator, shortLength, longLength, movingAverageSupplier));
    }

    protected MovingAverageConvergenceDivergence(Indicator<Num> indicator, int shortLength, int longLength, MovingAverageSupplier movingAverageSupplier) {
        super(indicator.getSeries(), Math.max(shortLength, longLength));
        Preconditions.checkArgument((shortLength > 0 ? 1 : 0) != 0, (Object)"'shortLength' must be greater than zero!");
        Preconditions.checkArgument((longLength > 0 ? 1 : 0) != 0, (Object)"'longLength' must be greater than zero!");
        this.shortMa = movingAverageSupplier.supply(indicator, shortLength);
        this.longMa = movingAverageSupplier.supply(indicator, longLength);
    }

    @Override
    protected Num calculate(long index) {
        return this.shortMa.getValue(index).subtract(this.longMa.getValue(index));
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int shortLength;
        private final int longLength;
        private final MovingAverageSupplier movingAverageSupplier;

        @Generated
        public CacheKey(Indicator<Num> indicator, int shortLength, int longLength, MovingAverageSupplier movingAverageSupplier) {
            this.indicator = indicator;
            this.shortLength = shortLength;
            this.longLength = longLength;
            this.movingAverageSupplier = movingAverageSupplier;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getShortLength() {
            return this.shortLength;
        }

        @Generated
        public int getLongLength() {
            return this.longLength;
        }

        @Generated
        public MovingAverageSupplier getMovingAverageSupplier() {
            return this.movingAverageSupplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getShortLength() != other.getShortLength()) {
                return false;
            }
            if (this.getLongLength() != other.getLongLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            if (this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator)) {
                return false;
            }
            MovingAverageSupplier this$movingAverageSupplier = this.getMovingAverageSupplier();
            MovingAverageSupplier other$movingAverageSupplier = other.getMovingAverageSupplier();
            return !(this$movingAverageSupplier == null ? other$movingAverageSupplier != null : !((Object)this$movingAverageSupplier).equals(other$movingAverageSupplier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getShortLength();
            result = result * 59 + this.getLongLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            MovingAverageSupplier $movingAverageSupplier = this.getMovingAverageSupplier();
            result = result * 59 + ($movingAverageSupplier == null ? 43 : ((Object)$movingAverageSupplier).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MovingAverageConvergenceDivergence.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", shortLength=" + this.getShortLength() + ", longLength=" + this.getLongLength() + ", movingAverageSupplier=" + String.valueOf(this.getMovingAverageSupplier()) + ")";
        }
    }
}

