/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.obv;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.RecursiveIndicator;
import trade.invision.indicators.indicator.bar.Close;
import trade.invision.indicators.indicator.bar.Volume;
import trade.invision.indicators.indicator.previous.PreviousValue;
import trade.invision.indicators.series.bar.BarSeries;
import trade.invision.num.Num;

public class OnBalanceVolume
extends RecursiveIndicator<Num> {
    private static final Cache<CacheKey, OnBalanceVolume> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Close close;
    private final Indicator<Num> previousClose;
    private final Indicator<Num> volume;

    public static OnBalanceVolume obv(BarSeries barSeries) {
        return OnBalanceVolume.onBalanceVolume(barSeries);
    }

    public static OnBalanceVolume onBalanceVolume(BarSeries barSeries) {
        return (OnBalanceVolume)CACHE.get((Object)new CacheKey(barSeries), key -> new OnBalanceVolume(barSeries));
    }

    protected OnBalanceVolume(BarSeries barSeries) {
        super(barSeries, 1);
        this.volume = Volume.volume(barSeries);
        this.close = Close.close(barSeries);
        this.previousClose = PreviousValue.previousValue(this.close);
    }

    @Override
    protected Num calculate(long index) {
        if (index == 0L) {
            return this.numOfZero();
        }
        Num previousCloseValue = this.previousClose.getValue(index);
        Num closeValue = (Num)this.close.getValue(index);
        Num previousValue = (Num)this.getValue(index - 1L);
        if (closeValue.isGreaterThan(previousCloseValue)) {
            previousValue = previousValue.add(this.volume.getValue(index));
        } else if (closeValue.isLessThan(previousCloseValue)) {
            previousValue = previousValue.subtract(this.volume.getValue(index));
        }
        return previousValue;
    }

    private static final class CacheKey {
        private final BarSeries barSeries;

        @Generated
        public CacheKey(BarSeries barSeries) {
            this.barSeries = barSeries;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            return !(this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OnBalanceVolume.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ")";
        }
    }
}

