/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.operation.binary;

import java.util.function.BiFunction;
import trade.invision.indicators.indicator.Indicator;

public class BinaryOperation<A, B, R>
extends Indicator<R> {
    private final BiFunction<A, B, R> operator;
    private final Indicator<A> firstOperand;
    private final Indicator<B> secondOperand;

    public static <A, B, R> BinaryOperation<A, B, R> binaryOperation(BiFunction<A, B, R> operator, Indicator<A> firstOperand, Indicator<B> secondOperand) {
        return new BinaryOperation<A, B, R>(operator, firstOperand, secondOperand);
    }

    protected BinaryOperation(BiFunction<A, B, R> operator, Indicator<A> firstOperand, Indicator<B> secondOperand) {
        super(firstOperand.getSeries(), Math.max(firstOperand.getMinimumStableIndex(), secondOperand.getMinimumStableIndex()));
        this.operator = operator;
        this.firstOperand = firstOperand;
        this.secondOperand = secondOperand;
    }

    @Override
    protected R calculate(long index) {
        return this.operator.apply(this.firstOperand.getValue(index), this.secondOperand.getValue(index));
    }
}

