/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.operation.binary;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.operation.binary.BinaryOperation;

public final class InstantBinaryOperations {
    public static Indicator<Instant> earliest(Indicator<Instant> left, Indicator<Instant> right) {
        return BinaryOperation.binaryOperation((l, r) -> l.isBefore((Instant)r) ? l : r, left, right);
    }

    public static Indicator<Instant> latest(Indicator<Instant> left, Indicator<Instant> right) {
        return BinaryOperation.binaryOperation((l, r) -> l.isAfter((Instant)r) ? l : r, left, right);
    }

    public static Indicator<Instant> withTime(Indicator<Instant> left, Indicator<Instant> right) {
        return InstantBinaryOperations.withTime(left, right, ZoneOffset.UTC);
    }

    public static Indicator<Instant> withTime(Indicator<Instant> left, Indicator<Instant> right, ZoneId zoneId) {
        return BinaryOperation.binaryOperation((l, r) -> l.atZone(zoneId).with(r.atZone(zoneId).toLocalTime()).toInstant(), left, right);
    }

    public static Indicator<Instant> withDate(Indicator<Instant> left, Indicator<Instant> right) {
        return InstantBinaryOperations.withDate(left, right, ZoneOffset.UTC);
    }

    public static Indicator<Instant> withDate(Indicator<Instant> left, Indicator<Instant> right, ZoneId zoneId) {
        return BinaryOperation.binaryOperation((l, r) -> l.atZone(zoneId).with(r.atZone(zoneId).toLocalDate()).toInstant(), left, right);
    }

    public static Indicator<Boolean> isEqual(Indicator<Instant> left, Indicator<Instant> right) {
        return BinaryOperation.binaryOperation(Instant::equals, left, right);
    }

    public static Indicator<Boolean> isBefore(Indicator<Instant> left, Indicator<Instant> right) {
        return BinaryOperation.binaryOperation(Instant::isBefore, left, right);
    }

    public static Indicator<Boolean> isBeforeOrEqual(Indicator<Instant> left, Indicator<Instant> right) {
        return BinaryOperation.binaryOperation((l, r) -> !l.isAfter((Instant)r), left, right);
    }

    public static Indicator<Boolean> isAfter(Indicator<Instant> left, Indicator<Instant> right) {
        return BinaryOperation.binaryOperation(Instant::isAfter, left, right);
    }

    public static Indicator<Boolean> isAfterOrEqual(Indicator<Instant> left, Indicator<Instant> right) {
        return BinaryOperation.binaryOperation((l, r) -> !l.isBefore((Instant)r), left, right);
    }

    public static Indicator<Boolean> isTimeEqual(Indicator<Instant> left, Indicator<Instant> right) {
        return InstantBinaryOperations.isTimeEqual(left, right, ZoneOffset.UTC);
    }

    public static Indicator<Boolean> isTimeEqual(Indicator<Instant> left, Indicator<Instant> right, ZoneId zoneId) {
        return BinaryOperation.binaryOperation((l, r) -> l.atZone(zoneId).toLocalTime().equals(r.atZone(zoneId).toLocalTime()), left, right);
    }

    public static Indicator<Boolean> isTimeBefore(Indicator<Instant> left, Indicator<Instant> right) {
        return InstantBinaryOperations.isTimeBefore(left, right, ZoneOffset.UTC);
    }

    public static Indicator<Boolean> isTimeBefore(Indicator<Instant> left, Indicator<Instant> right, ZoneId zoneId) {
        return BinaryOperation.binaryOperation((l, r) -> l.atZone(zoneId).toLocalTime().isBefore(r.atZone(zoneId).toLocalTime()), left, right);
    }

    public static Indicator<Boolean> isTimeBeforeOrEqual(Indicator<Instant> left, Indicator<Instant> right) {
        return InstantBinaryOperations.isTimeBeforeOrEqual(left, right, ZoneOffset.UTC);
    }

    public static Indicator<Boolean> isTimeBeforeOrEqual(Indicator<Instant> left, Indicator<Instant> right, ZoneId zoneId) {
        return BinaryOperation.binaryOperation((l, r) -> !l.atZone(zoneId).toLocalTime().isAfter(r.atZone(zoneId).toLocalTime()), left, right);
    }

    public static Indicator<Boolean> isTimeAfter(Indicator<Instant> left, Indicator<Instant> right) {
        return InstantBinaryOperations.isTimeAfter(left, right, ZoneOffset.UTC);
    }

    public static Indicator<Boolean> isTimeAfter(Indicator<Instant> left, Indicator<Instant> right, ZoneId zoneId) {
        return BinaryOperation.binaryOperation((l, r) -> l.atZone(zoneId).toLocalTime().isAfter(r.atZone(zoneId).toLocalTime()), left, right);
    }

    public static Indicator<Boolean> isTimeAfterOrEqual(Indicator<Instant> left, Indicator<Instant> right) {
        return InstantBinaryOperations.isTimeAfterOrEqual(left, right, ZoneOffset.UTC);
    }

    public static Indicator<Boolean> isTimeAfterOrEqual(Indicator<Instant> left, Indicator<Instant> right, ZoneId zoneId) {
        return BinaryOperation.binaryOperation((l, r) -> !l.atZone(zoneId).toLocalTime().isBefore(r.atZone(zoneId).toLocalTime()), left, right);
    }

    public static Indicator<Boolean> isDateEqual(Indicator<Instant> left, Indicator<Instant> right) {
        return InstantBinaryOperations.isDateEqual(left, right, ZoneOffset.UTC);
    }

    public static Indicator<Boolean> isDateEqual(Indicator<Instant> left, Indicator<Instant> right, ZoneId zoneId) {
        return BinaryOperation.binaryOperation((l, r) -> l.atZone(zoneId).toLocalDate().equals(r.atZone(zoneId).toLocalDate()), left, right);
    }

    public static Indicator<Boolean> isDateBefore(Indicator<Instant> left, Indicator<Instant> right) {
        return InstantBinaryOperations.isDateBefore(left, right, ZoneOffset.UTC);
    }

    public static Indicator<Boolean> isDateBefore(Indicator<Instant> left, Indicator<Instant> right, ZoneId zoneId) {
        return BinaryOperation.binaryOperation((l, r) -> l.atZone(zoneId).toLocalDate().isBefore(r.atZone(zoneId).toLocalDate()), left, right);
    }

    public static Indicator<Boolean> isDateBeforeOrEqual(Indicator<Instant> left, Indicator<Instant> right) {
        return InstantBinaryOperations.isDateBeforeOrEqual(left, right, ZoneOffset.UTC);
    }

    public static Indicator<Boolean> isDateBeforeOrEqual(Indicator<Instant> left, Indicator<Instant> right, ZoneId zoneId) {
        return BinaryOperation.binaryOperation((l, r) -> !l.atZone(zoneId).toLocalDate().isAfter(r.atZone(zoneId).toLocalDate()), left, right);
    }

    public static Indicator<Boolean> isDateAfter(Indicator<Instant> left, Indicator<Instant> right) {
        return InstantBinaryOperations.isDateAfter(left, right, ZoneOffset.UTC);
    }

    public static Indicator<Boolean> isDateAfter(Indicator<Instant> left, Indicator<Instant> right, ZoneId zoneId) {
        return BinaryOperation.binaryOperation((l, r) -> l.atZone(zoneId).toLocalDate().isAfter(r.atZone(zoneId).toLocalDate()), left, right);
    }

    public static Indicator<Boolean> isDateAfterOrEqual(Indicator<Instant> left, Indicator<Instant> right) {
        return InstantBinaryOperations.isDateAfterOrEqual(left, right, ZoneOffset.UTC);
    }

    public static Indicator<Boolean> isDateAfterOrEqual(Indicator<Instant> left, Indicator<Instant> right, ZoneId zoneId) {
        return BinaryOperation.binaryOperation((l, r) -> !l.atZone(zoneId).toLocalDate().isBefore(r.atZone(zoneId).toLocalDate()), left, right);
    }
}

