/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.previous;

import com.google.common.base.Preconditions;
import trade.invision.indicators.indicator.CachelessIndicator;
import trade.invision.indicators.indicator.Indicator;

public class PreviousValue<T>
extends CachelessIndicator<T> {
    private final Indicator<T> indicator;
    private final int n;

    public static <T> PreviousValue<T> previousValue(Indicator<T> indicator) {
        return new PreviousValue<T>(indicator, 1);
    }

    public static <T> PreviousValue<T> previousValue(Indicator<T> indicator, int n) {
        return new PreviousValue<T>(indicator, n);
    }

    protected PreviousValue(Indicator<T> indicator, int n) {
        super(indicator.getSeries(), n);
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"'n' must be greater than zero!");
        this.indicator = indicator.caching();
        this.n = n;
    }

    @Override
    protected T calculate(long index) {
        return this.indicator.getValue(Math.max(0L, index - (long)this.n));
    }
}

