/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.pvo;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.Generated;
import trade.invision.indicators.indicator.bar.Volume;
import trade.invision.indicators.indicator.ma.MovingAverageSupplier;
import trade.invision.indicators.indicator.ppo.PercentagePriceOscillator;
import trade.invision.indicators.series.bar.BarSeries;

public class PercentageVolumeOscillator
extends PercentagePriceOscillator {
    private static final Cache<CacheKey, PercentageVolumeOscillator> CACHE = Caffeine.newBuilder().weakValues().build();

    public static PercentageVolumeOscillator pvo(BarSeries barSeries, int shortLength, int longLength, MovingAverageSupplier movingAverageSupplier) {
        return PercentageVolumeOscillator.percentageVolumeOscillator(barSeries, shortLength, longLength, movingAverageSupplier);
    }

    public static PercentageVolumeOscillator percentageVolumeOscillator(BarSeries barSeries, int shortLength, int longLength, MovingAverageSupplier movingAverageSupplier) {
        return (PercentageVolumeOscillator)CACHE.get((Object)new CacheKey(barSeries, shortLength, longLength, movingAverageSupplier), key -> new PercentageVolumeOscillator(barSeries, shortLength, longLength, movingAverageSupplier));
    }

    protected PercentageVolumeOscillator(BarSeries barSeries, int shortLength, int longLength, MovingAverageSupplier movingAverageSupplier) {
        super(Volume.volume(barSeries), shortLength, longLength, movingAverageSupplier);
    }

    private static final class CacheKey {
        private final BarSeries barSeries;
        private final int shortLength;
        private final int longLength;
        private final MovingAverageSupplier movingAverageSupplier;

        @Generated
        public CacheKey(BarSeries barSeries, int shortLength, int longLength, MovingAverageSupplier movingAverageSupplier) {
            this.barSeries = barSeries;
            this.shortLength = shortLength;
            this.longLength = longLength;
            this.movingAverageSupplier = movingAverageSupplier;
        }

        @Generated
        public BarSeries getBarSeries() {
            return this.barSeries;
        }

        @Generated
        public int getShortLength() {
            return this.shortLength;
        }

        @Generated
        public int getLongLength() {
            return this.longLength;
        }

        @Generated
        public MovingAverageSupplier getMovingAverageSupplier() {
            return this.movingAverageSupplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getShortLength() != other.getShortLength()) {
                return false;
            }
            if (this.getLongLength() != other.getLongLength()) {
                return false;
            }
            BarSeries this$barSeries = this.getBarSeries();
            BarSeries other$barSeries = other.getBarSeries();
            if (this$barSeries == null ? other$barSeries != null : !this$barSeries.equals(other$barSeries)) {
                return false;
            }
            MovingAverageSupplier this$movingAverageSupplier = this.getMovingAverageSupplier();
            MovingAverageSupplier other$movingAverageSupplier = other.getMovingAverageSupplier();
            return !(this$movingAverageSupplier == null ? other$movingAverageSupplier != null : !((Object)this$movingAverageSupplier).equals(other$movingAverageSupplier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getShortLength();
            result = result * 59 + this.getLongLength();
            BarSeries $barSeries = this.getBarSeries();
            result = result * 59 + ($barSeries == null ? 43 : $barSeries.hashCode());
            MovingAverageSupplier $movingAverageSupplier = this.getMovingAverageSupplier();
            result = result * 59 + ($movingAverageSupplier == null ? 43 : ((Object)$movingAverageSupplier).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PercentageVolumeOscillator.CacheKey(barSeries=" + String.valueOf(this.getBarSeries()) + ", shortLength=" + this.getShortLength() + ", longLength=" + this.getLongLength() + ", movingAverageSupplier=" + String.valueOf(this.getMovingAverageSupplier()) + ")";
        }
    }
}

