/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.risingfalling.global;

import java.util.function.BiPredicate;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.RecursiveIndicator;
import trade.invision.num.Num;

abstract class AbstractGlobalRisingFallingPercentage
extends RecursiveIndicator<Num> {
    private final Indicator<Num> indicator;
    private final BiPredicate<Num, Num> predicate;

    protected AbstractGlobalRisingFallingPercentage(Indicator<Num> indicator, boolean rising) {
        super(indicator.getSeries(), 1);
        this.indicator = indicator.caching();
        this.predicate = rising ? Num::isGreaterThan : Num::isLessThan;
    }

    @Override
    protected Num calculate(long index) {
        if (index == 0L) {
            return this.numOfZero();
        }
        long previousIndex = index - 1L;
        Num previousValue = (Num)this.getValue(previousIndex);
        Num count = previousValue.multiply((Number)previousIndex);
        if (this.predicate.test(this.indicator.getValue(index), this.indicator.getValue(previousIndex))) {
            count = count.increment();
        }
        return count.divide((Number)index);
    }
}

