/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.risingfalling.local;

import com.google.common.base.Preconditions;
import java.util.function.BiPredicate;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.num.Num;

abstract class AbstractLocalRisingFallingPercentage
extends Indicator<Num> {
    private final Indicator<Num> indicator;
    private final int length;
    private final BiPredicate<Num, Num> predicate;

    protected AbstractLocalRisingFallingPercentage(Indicator<Num> indicator, int length, boolean rising) {
        super(indicator.getSeries(), 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.indicator = indicator.caching();
        this.length = length;
        this.predicate = rising ? Num::isGreaterThan : Num::isLessThan;
    }

    @Override
    protected Num calculate(long index) {
        long startIndex = Math.max(1L, index - (long)this.length + 1L);
        long observations = index - startIndex + 1L;
        int count = 0;
        for (long indicatorIndex = startIndex; indicatorIndex <= index; ++indicatorIndex) {
            if (!this.predicate.test(this.indicator.getValue(indicatorIndex), this.indicator.getValue(indicatorIndex - 1L))) continue;
            ++count;
        }
        return this.numOf(count).divide((Number)observations);
    }
}

