/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.rsi;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.gainloss.Gain;
import trade.invision.indicators.indicator.gainloss.Loss;
import trade.invision.indicators.indicator.ma.MovingAverageSupplier;
import trade.invision.num.Num;

public class RelativeStrengthIndex
extends Indicator<Num> {
    private static final Cache<CacheKey, RelativeStrengthIndex> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> averageGain;
    private final Indicator<Num> averageLoss;

    public static RelativeStrengthIndex rsi(Indicator<Num> indicator, int length, MovingAverageSupplier movingAverageSupplier) {
        return RelativeStrengthIndex.relativeStrengthIndex(indicator, length, movingAverageSupplier);
    }

    public static RelativeStrengthIndex relativeStrengthIndex(Indicator<Num> indicator, int length, MovingAverageSupplier movingAverageSupplier) {
        return (RelativeStrengthIndex)CACHE.get((Object)new CacheKey(indicator, length, movingAverageSupplier), key -> new RelativeStrengthIndex(indicator, length, movingAverageSupplier));
    }

    protected RelativeStrengthIndex(Indicator<Num> indicator, int length, MovingAverageSupplier movingAverageSupplier) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.averageGain = movingAverageSupplier.supply(Gain.gain(indicator), length);
        this.averageLoss = movingAverageSupplier.supply(Loss.loss(indicator), length);
    }

    @Override
    protected Num calculate(long index) {
        Num gain = this.averageGain.getValue(index);
        Num loss = this.averageLoss.getValue(index);
        if (loss.isZero(this.series.getEpsilon())) {
            return gain.isZero(this.series.getEpsilon()) ? this.numOfZero() : this.numOfHundred();
        }
        return this.numOfHundred().subtract(this.numOfHundred().divide(this.numOfOne().add(gain.divide(loss)))).ifNaN(this.numOfHundred());
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;
        private final MovingAverageSupplier movingAverageSupplier;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length, MovingAverageSupplier movingAverageSupplier) {
            this.indicator = indicator;
            this.length = length;
            this.movingAverageSupplier = movingAverageSupplier;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public MovingAverageSupplier getMovingAverageSupplier() {
            return this.movingAverageSupplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            if (this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator)) {
                return false;
            }
            MovingAverageSupplier this$movingAverageSupplier = this.getMovingAverageSupplier();
            MovingAverageSupplier other$movingAverageSupplier = other.getMovingAverageSupplier();
            return !(this$movingAverageSupplier == null ? other$movingAverageSupplier != null : !((Object)this$movingAverageSupplier).equals(other$movingAverageSupplier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            MovingAverageSupplier $movingAverageSupplier = this.getMovingAverageSupplier();
            result = result * 59 + ($movingAverageSupplier == null ? 43 : ((Object)$movingAverageSupplier).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RelativeStrengthIndex.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ", movingAverageSupplier=" + String.valueOf(this.getMovingAverageSupplier()) + ")";
        }
    }
}

