/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.rsi;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.extrema.local.LocalMaximum;
import trade.invision.indicators.indicator.extrema.local.LocalMinimum;
import trade.invision.indicators.indicator.ma.MovingAverageSupplier;
import trade.invision.indicators.indicator.rsi.RelativeStrengthIndex;
import trade.invision.num.Num;

public class StochasticRelativeStrengthIndex
extends Indicator<Num> {
    private static final Cache<CacheKey, StochasticRelativeStrengthIndex> CACHE = Caffeine.newBuilder().weakValues().build();
    private final RelativeStrengthIndex rsi;
    private final LocalMinimum minRsi;
    private final LocalMaximum maxRsi;

    public static StochasticRelativeStrengthIndex stochrsi(Indicator<Num> indicator, int length, MovingAverageSupplier movingAverageSupplier) {
        return StochasticRelativeStrengthIndex.stochasticRelativeStrengthIndex(indicator, length, movingAverageSupplier);
    }

    public static StochasticRelativeStrengthIndex stochasticRelativeStrengthIndex(Indicator<Num> indicator, int length, MovingAverageSupplier movingAverageSupplier) {
        return (StochasticRelativeStrengthIndex)CACHE.get((Object)new CacheKey(indicator, length, movingAverageSupplier), key -> new StochasticRelativeStrengthIndex(indicator, length, movingAverageSupplier));
    }

    protected StochasticRelativeStrengthIndex(Indicator<Num> indicator, int length, MovingAverageSupplier movingAverageSupplier) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.rsi = RelativeStrengthIndex.relativeStrengthIndex(indicator, length, movingAverageSupplier);
        this.minRsi = LocalMinimum.localMinimum(this.rsi, length);
        this.maxRsi = LocalMaximum.localMaximum(this.rsi, length);
    }

    @Override
    protected Num calculate(long index) {
        Num minRsiValue = (Num)this.minRsi.getValue(index);
        Num maxRsiValue = (Num)this.maxRsi.getValue(index);
        return ((Num)this.rsi.getValue(index)).subtract(minRsiValue).divide(maxRsiValue.subtract(minRsiValue));
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;
        private final MovingAverageSupplier movingAverageSupplier;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length, MovingAverageSupplier movingAverageSupplier) {
            this.indicator = indicator;
            this.length = length;
            this.movingAverageSupplier = movingAverageSupplier;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public MovingAverageSupplier getMovingAverageSupplier() {
            return this.movingAverageSupplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            if (this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator)) {
                return false;
            }
            MovingAverageSupplier this$movingAverageSupplier = this.getMovingAverageSupplier();
            MovingAverageSupplier other$movingAverageSupplier = other.getMovingAverageSupplier();
            return !(this$movingAverageSupplier == null ? other$movingAverageSupplier != null : !((Object)this$movingAverageSupplier).equals(other$movingAverageSupplier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            MovingAverageSupplier $movingAverageSupplier = this.getMovingAverageSupplier();
            result = result * 59 + ($movingAverageSupplier == null ? 43 : ((Object)$movingAverageSupplier).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StochasticRelativeStrengthIndex.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ", movingAverageSupplier=" + String.valueOf(this.getMovingAverageSupplier()) + ")";
        }
    }
}

