/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.statistical;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.ma.sma.SimpleMovingAverage;
import trade.invision.num.Num;

public class Covariance
extends Indicator<Num> {
    private static final Cache<CacheKey, Covariance> CACHE = Caffeine.newBuilder().weakValues().build();
    private final Indicator<Num> first;
    private final Indicator<Num> second;
    private final int length;
    private final boolean unbiased;
    private final SimpleMovingAverage sma1;
    private final SimpleMovingAverage sma2;

    public static Covariance covar(Indicator<Num> first, Indicator<Num> second, int length, boolean unbiased) {
        return Covariance.covariance(first, second, length, unbiased);
    }

    public static Covariance covariance(Indicator<Num> first, Indicator<Num> second, int length, boolean unbiased) {
        return (Covariance)CACHE.get((Object)new CacheKey(first, second, length, unbiased), key -> new Covariance(first, second, length, unbiased));
    }

    protected Covariance(Indicator<Num> first, Indicator<Num> second, int length, boolean unbiased) {
        super(first.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.first = first.caching();
        this.second = second.caching();
        this.length = length;
        this.unbiased = unbiased;
        this.sma1 = SimpleMovingAverage.simpleMovingAverage(first, length);
        this.sma2 = SimpleMovingAverage.simpleMovingAverage(second, length);
    }

    @Override
    protected Num calculate(long index) {
        long startIndex = Math.max(0L, index - (long)this.length + 1L);
        long observations = index - startIndex + 1L;
        Num average1 = (Num)this.sma1.getValue(index);
        Num average2 = (Num)this.sma2.getValue(index);
        Num covariance = this.numOfZero();
        for (long indicatorIndex = startIndex; indicatorIndex <= index; ++indicatorIndex) {
            covariance = covariance.add(this.first.getValue(indicatorIndex).subtract(average1).multiply(this.second.getValue(indicatorIndex).subtract(average2)));
        }
        return covariance.divide((Number)(this.unbiased ? Math.max(1L, observations - 1L) : observations));
    }

    private static final class CacheKey {
        private final Indicator<Num> first;
        private final Indicator<Num> second;
        private final int length;
        private final boolean unbiased;

        @Generated
        public CacheKey(Indicator<Num> first, Indicator<Num> second, int length, boolean unbiased) {
            this.first = first;
            this.second = second;
            this.length = length;
            this.unbiased = unbiased;
        }

        @Generated
        public Indicator<Num> getFirst() {
            return this.first;
        }

        @Generated
        public Indicator<Num> getSecond() {
            return this.second;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean isUnbiased() {
            return this.unbiased;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            if (this.isUnbiased() != other.isUnbiased()) {
                return false;
            }
            Indicator<Num> this$first = this.getFirst();
            Indicator<Num> other$first = other.getFirst();
            if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
                return false;
            }
            Indicator<Num> this$second = this.getSecond();
            Indicator<Num> other$second = other.getSecond();
            return !(this$second == null ? other$second != null : !this$second.equals(other$second));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            result = result * 59 + (this.isUnbiased() ? 79 : 97);
            Indicator<Num> $first = this.getFirst();
            result = result * 59 + ($first == null ? 43 : $first.hashCode());
            Indicator<Num> $second = this.getSecond();
            result = result * 59 + ($second == null ? 43 : $second.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Covariance.CacheKey(first=" + String.valueOf(this.getFirst()) + ", second=" + String.valueOf(this.getSecond()) + ", length=" + this.getLength() + ", unbiased=" + this.isUnbiased() + ")";
        }
    }
}

