/*
 * Decompiled with CFR 0.152.
 */
package trade.invision.indicators.indicator.statistical;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import lombok.Generated;
import trade.invision.indicators.indicator.Indicator;
import trade.invision.indicators.indicator.cumulative.CumulativeSum;
import trade.invision.indicators.indicator.operation.unary.NumUnaryOperations;
import trade.invision.num.Num;

public class RootMeanSquare
extends Indicator<Num> {
    private static final Cache<CacheKey, RootMeanSquare> CACHE = Caffeine.newBuilder().weakValues().build();
    private final int length;
    private final CumulativeSum squaredSum;

    public static RootMeanSquare rms(Indicator<Num> indicator, int length) {
        return RootMeanSquare.rootMeanSquare(indicator, length);
    }

    public static RootMeanSquare rootMeanSquare(Indicator<Num> indicator, int length) {
        return (RootMeanSquare)CACHE.get((Object)new CacheKey(indicator, length), key -> new RootMeanSquare(indicator, length));
    }

    protected RootMeanSquare(Indicator<Num> indicator, int length) {
        super(indicator.getSeries(), length - 1);
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"'length' must be greater than zero!");
        this.length = length;
        this.squaredSum = CumulativeSum.cumulativeSum(NumUnaryOperations.square(indicator), length);
    }

    @Override
    protected Num calculate(long index) {
        return ((Num)this.squaredSum.getValue(index)).divide((Number)Math.min(index + 1L, (long)this.length)).squareRoot();
    }

    private static final class CacheKey {
        private final Indicator<Num> indicator;
        private final int length;

        @Generated
        public CacheKey(Indicator<Num> indicator, int length) {
            this.indicator = indicator;
            this.length = length;
        }

        @Generated
        public Indicator<Num> getIndicator() {
            return this.indicator;
        }

        @Generated
        public int getLength() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (this.getLength() != other.getLength()) {
                return false;
            }
            Indicator<Num> this$indicator = this.getIndicator();
            Indicator<Num> other$indicator = other.getIndicator();
            return !(this$indicator == null ? other$indicator != null : !this$indicator.equals(other$indicator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLength();
            Indicator<Num> $indicator = this.getIndicator();
            result = result * 59 + ($indicator == null ? 43 : $indicator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RootMeanSquare.CacheKey(indicator=" + String.valueOf(this.getIndicator()) + ", length=" + this.getLength() + ")";
        }
    }
}

